# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-03-29 11:23
from __future__ import unicode_literals, print_function

import sys
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

def update_existing_users(*args, **kwargs):
    if not 'test' in sys.argv[1:]:
        from django.contrib.auth import get_user_model
        print("\nPerforming LDAP queries for existing users.", end='')
        for user in get_user_model().objects.all():
            sys.stdout.write('.')
            sys.stdout.flush()
            user.save()

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='UvtUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(blank=True, max_length=255)),
                ('full_name', models.CharField(blank=True, max_length=255)),
                ('ANR', models.CharField(blank=True, max_length=255)),
                ('email', models.CharField(blank=True, max_length=255)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='uvt_user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.RunPython(update_existing_users),
    ]
