<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xhtml="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:ss="http://tilburguniversity.edu/stylesheets">

	<xsl:import href="common.xsl"/>

	<xsl:template match="xhtml:document" mode="title">
		<xsl:value-of select="xhtml:title"/>
		<xsl:text> – </xsl:text>
	</xsl:template>

	<xsl:template match="xhtml:document">
		<xsl:apply-templates select="xhtml:content/node()" mode="whitespace"/>
	</xsl:template>

	<xsl:template match="xhtml:content/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:div/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:table/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:tr/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:ul/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:ol/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:dl/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:form/text()[normalize-space()='']" mode="whitespace"/>
	<xsl:template match="xhtml:select/text()[normalize-space()='']" mode="whitespace"/>

	<xsl:template match="@*|node()" mode="whitespace">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" mode="whitespace"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
