<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:ss="http://tilburguniversity.edu/stylesheets" version="1.0" ss:hack="meh" exclude-result-prefixes="ss html"><xsl:output method="xml" media-type="application/xhtml+xml" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/><xsl:template match="/*"><html lang="en" xml:lang="en"><head><xsl:apply-templates select="ss:meta/node()" mode="verbatim"/><meta name="DCTERMS.modified" content="2014-06-04"/><meta name="DCTERMS.created" content="2012-09-11"/><meta name="languagecode" content="english"/><meta name="DCTERMS.rights" content="Tilburg University"/><meta name="DC.title" content="- titel -"/><meta name="keywords" content="Tilburg University"><xsl:attribute name="content"><xsl:value-of select="ss:keywords"/></xsl:attribute></meta><meta name="Googlebot" content="index,archive,follow"/><meta name="generated" content="05/11/2014"/><meta name="pageid" content="329594"/><meta name="metachannel" content="internet"/><xsl:comment> normal render </xsl:comment><xsl:if test="../ss:big-brother"><script xml:space="preserve"><xsl:text>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</xsl:text></script></xsl:if><title><xsl:apply-templates select="ss:title"/><xsl:text> – Tilburg University</xsl:text></title><xsl:if test="ss:big-brother"><script language="javascript" type="text/javascript" xml:space="preserve"><xsl:comment>
	var _gaq = _gaq || [];
	try {
		_gaq.push(
			['_setAccount', 'UA-19568693-1'],
			['_trackPageview']
		);
	} catch(err) {}
	function addGa(articleid, articletype, articletitle) {
		try {
			_gaq.push(
				['_trackEvent', articletype, articletitle, articleid]
			);
		} catch(err) {}
	};
//</xsl:comment></script></xsl:if><link href="//www.tilburguniversity.edu/static/uvtpresentation/css/bootstrap.css" rel="stylesheet" media="screen"/><link rel="shortcut icon" href="//www.tilburguniversity.edu/static/uvtpresentation/images/favicon.ico" type="image/x-icon"/><link href="//www.tilburguniversity.edu/static/uvtpresentation/css/jquery-ui.css" rel="stylesheet" media="screen"/><link href="//www.tilburguniversity.edu/static/uvtpresentation/css/style.css" rel="stylesheet" media="screen"/><!--[if lte IE 8]> <link href="//www.tilburguniversity.edu/static/uvtpresentation/css/style_ie.css" rel="stylesheet" media="screen" /><![endif]--><link media="print" rel="stylesheet" href="//www.tilburguniversity.edu/static/uvtpresentation/css/print.css" type="text/css"/><link rel="stylesheet" href="//www.tilburguniversity.edu/static/uvtpresentation/js/fancybox/jquery.fancybox-1.3.4.css" type="text/css" media="screen"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquery-1.4.2.min.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquery.easing.1.3.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquery-ui-1.8.2.custom.min.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquery.cycle.all.min.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/cufon-yui.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/cufon.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquerycssmenu.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/shadowbox.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/jquery.scripts.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/bubble.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/fancybox/jquery.fancybox-1.3.4.js" xml:space="preserve"/><xsl:comment> GX Added </xsl:comment><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/study_expenses.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/webmanager.grid.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/wm/f/lib.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/wm.yammer.integration.js" xml:space="preserve"/><xsl:comment>  Silverlight video player </xsl:comment><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/silverlightvideo/silverlight.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/silverlightvideo/wmvplayer.js" xml:space="preserve"/><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/gx/flash/swfobject.js" xml:space="preserve"/><xsl:apply-templates select="ss:head/node()" mode="verbatim"/></head><body><xsl:comment> indexer: off </xsl:comment><div id="wrapper"><xsl:comment> HEADER </xsl:comment><xsl:comment> HEADER TYPE: content</xsl:comment><div id="contentWrapper" class="smallBG smallBG_{ss:colorbar/ss:color}"><div id="wrapperContentText"><div class="smallBlock"><h1><xsl:apply-templates select="ss:colorbar/ss:title/node()" mode="verbatim"/></h1><p><xsl:apply-templates select="ss:colorbar/ss:message/node()" mode="verbatim"/></p></div><div class="headerHighlights"><xsl:apply-templates select="ss:colorbar/ss:panels"/></div></div></div><div id="content"><xsl:comment> CONTENT </xsl:comment><div id="contentBlocks" class="clearfix "><xsl:apply-templates select="ss:navbar"/><div id="mainContentContainer" class="clearfix"><xsl:attribute name="class"><xsl:choose><xsl:when test="ss:sidebar and ss:navbar">clearfix</xsl:when><xsl:when test="ss:sidebar or ss:navbar">clearfix wide</xsl:when><xsl:otherwise>clearfix extraWide</xsl:otherwise></xsl:choose></xsl:attribute><xsl:apply-templates select="ss:content"/></div><xsl:apply-templates select="ss:sidebar"/><xsl:comment> sidebar </xsl:comment></div></div></div><div style="display:none"><div id="mailafriendform"/></div><div style="display:none"><div id="reactionform"/></div><div id="footer"><div class="footerContent"><div class="copyright"><xsl:text>Copyright 2014 Tilburg University</xsl:text></div><div class="disclaimer"><a rel="nofollow" href="//www.tilburguniversity.edu/disclaimer/" title="Disclaimer en cookies" shape="rect"><xsl:text>Disclaimer en cookies</xsl:text></a></div><div/></div></div><div id="main-nav"><div class="container"><div class="navbar yamm"><div id="navbar-collapse-grid" class="navbar-collapse collapse"><ul class="nav navbar-nav"><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>Education</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Bachelor's programs</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/bachelors-programs/" class="normal" title="Bachelor's programs" shape="rect"><xsl:text>All programs</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/bachelors-programs/admissionrequirements/" class="normal" title="Admission requirements" shape="rect"><xsl:text>Admission requirements</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/bachelors-programs/information-and-contact/" class="normal" title="Information and contact" shape="rect"><xsl:text>Information and contact</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/bachelors-programs/admissionprocedure/" class="normal" title="Application procedure" shape="rect"><xsl:text>Application</xsl:text></a></li><li/><li/></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Master's programs</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/masters-programmes/" class="normal" title="Master's programs" shape="rect"><xsl:text>All programs</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/masters-programmes/advantages/" class="normal" title="Why do your Master's at Tilburg University?" shape="rect"><xsl:text>Why do your Master's at Tilburg University?</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/masters-programmes/scholarships/" class="normal" title="Scholarships and tuition fees" shape="rect"><xsl:text>Scholarships and tuition fees</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/masters-programmes/information-evening/" class="normal" title="Master's programs information evening - 26 November 2014" shape="rect"><xsl:text>Information Evening</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/masters-programmes/contact/" class="normal" title="Information and contact" shape="rect"><xsl:text>Information and contact</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Research Masters en PhD programs</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/research-masters-and-phd-programs/" class="normal" title="Research Masters and PhD programs" shape="rect"><xsl:text>Promoveren in Tilburg</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/research-masters-and-phd-programs/" class="normal" title="Research Masters and PhD programs" shape="rect"><xsl:text>Research Masters</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/research-masters-and-phd-programs/" class="normal" title="Research Masters and PhD programs" shape="rect"><xsl:text>Graduate schools</xsl:text></a></li></ul><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Post-experience programs</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/post-experience-programs/" class="normal" title="Post-experience programs" shape="rect"><xsl:text> Post Master opleidingen</xsl:text></a></li><li><a href="//www.tias.edu/en/" class="normal" title="//www.tias.edu/en/" shape="rect"><xsl:text>Tias Business School</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Quality in education</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/ranking/" class="normal" title="Rankings" shape="rect"><xsl:text>Rankings</xsl:text></a></li><li><xsl:comment>Quality assurance</xsl:comment></li></ul><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Extra</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/exchange-programs/" class="normal" title="Exchange programs" shape="rect"><xsl:text>Exchange programs</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/language-courses/" class="normal" title="Language Courses and more" shape="rect"><xsl:text>Language courses</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/summerschool/" class="normal" title="Tilburg University Summer School: serious fun!" shape="rect"><xsl:text>Summer school</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/education/contractteaching/" class="normal" title="Contract teaching" shape="rect"><xsl:text>Contract teaching</xsl:text></a></li><li/></ul><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>Research</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Topics</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><xsl:comment>Social Innovation</xsl:comment></li><li><a href="//www.tilburguniversity.edu/topic/sustainability-and-society/" class="normal" title="Sustainability" shape="rect"><xsl:text>Sustainability</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/topic/labor-market/" class="normal" title="Labor market" shape="rect"><xsl:text>Labor market</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/topic/security/" class="normal" title="Security" shape="rect"><xsl:text>Security</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/topic/religion-identity/" class="normal" title="Religion and identity" shape="rect"><xsl:text>Religion and identity</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/topic/aging/" class="normal" title="Aging" shape="rect"><xsl:text>Aging</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/topic/healthcare/" class="normal" title="Healthcare" shape="rect"><xsl:text>Healthcare</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Research areas</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/research/economics-and-management/" class="normal" title="Research Economics and management" shape="rect"><xsl:text>Economics and management</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/research/law/" class="normal" title="Research Tilburg Law School" shape="rect"><xsl:text>Law</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/research/humanities/" class="normal" title="Humanities research" shape="rect"><xsl:text>Humanities</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/research/social-and-behavioral-sciences/" class="normal" title="Social and Behavioral Sciences" shape="rect"><xsl:text>Social and behavioral sciences</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/research/theology/" class="normal" title="Theology" shape="rect"><xsl:text>Theology</xsl:text></a></li></ul><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><br/><br/><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Research institutes</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/research/institutes-and-research-groups/" class="normal" title="Institutes and research groups" shape="rect"><xsl:text>All research institutes</xsl:text></a></li><li><a href="https://www.tilburguniversity.edu/research/institutes-and-research-groups/intervict/" class="normal" title="https://www.tilburguniversity.edu/research/institutes-and-research-groups/intervict/" shape="rect"><xsl:text>Intervict</xsl:text></a></li><li><a href="http://www.netspar.nl/" class="normal" title="http://www.netspar.nl/" shape="rect"><xsl:text>Netspar</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/research/institutes-and-research-groups/tilec/" class="normal" title="//www.tilburguniversity.edu/research/institutes-and-research-groups/tilec/" shape="rect"><xsl:text>Tilec</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Search</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/webwijs/" class="normal" title="Experts &amp; Expertise" shape="rect"><xsl:text>Experts &amp; Expertise</xsl:text></a></li><li><a href="https://pure.uvt.nl/portal/en/publications/search.html" class="normal" title="https://pure.uvt.nl/portal/en/publications/search.html" shape="rect"><xsl:text>Publications</xsl:text></a></li><li><xsl:comment> &lt;a href="/research/commissioned-research/" class="normal" title="Commissioned Research"&gt;Persberichten&lt;/a&gt; </xsl:comment></li></ul><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Questions</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/research/commissioned-research/" class="normal" title="Commissioned Research" shape="rect"><xsl:text>Commissioned research</xsl:text></a></li><li><xsl:text>Press officers</xsl:text></li></ul><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>current</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>News and Events</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/current/news/" class="normal" title="News" shape="rect"><xsl:text>News</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/current/events/" class="normal" title="Events Tilburg University" shape="rect"><xsl:text>Events</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/current/communities/" class="normal" title="Communities" shape="rect"><xsl:text>Social Media</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/current/press-releases/" class="normal" title="International press releases" shape="rect"><xsl:text>Press releases</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/webwijs/pr-advisers.html" class="normal" title="//www.tilburguniversity.edu/webwijs/pr-advisers.html" shape="rect"><xsl:text>Press officers</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>campus</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Green campus</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="https://www.flickr.com/photos/tilburguniversity/" class="normal" title="https://www.flickr.com/photos/tilburguniversity/" shape="rect"><xsl:text>Campus photos</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/contact/campus-map/" class="normal" title="Tilburg University - Campus map" shape="rect"><xsl:text>Campus map</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/campus-tour/" class="normal" title="//www.tilburguniversity.edu/campus-tour/" shape="rect"><xsl:text>Campus tour</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/nl/over/schools/theologie/contact/" class="normal" title="//www.tilburguniversity.edu/nl/over/schools/theologie/contact/" shape="rect"><xsl:text>Location Utrecht</xsl:text></a></li><li><xsl:comment> Architectuur en kunst </xsl:comment></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Study and work space</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><xsl:comment> Onderzoekslabs </xsl:comment></li><li><a href="//www.tilburguniversity.edu/students/it/desktops/" class="normal" title="Studying on campus: student desktops" shape="rect"><xsl:text>Study places</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/culture-and-sports/sports-center/" class="normal" title="Sports Center" shape="rect"><xsl:text>Sports Center</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/culture-and-sports/academic-forum/" class="normal" title="Academic Forum" shape="rect"><xsl:text>Academic Forum</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Visit us</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/contact/route/" class="normal" title="Route description Tilburg University campus" shape="rect"><xsl:text>Route description</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/current/events/" class="normal" title="Events Tilburg University" shape="rect"><xsl:text>Events</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/contact/openinghours/" class="normal" title="Opening hours buildings" shape="rect"><xsl:text>Opening hours</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/contact/openinghours/restaurant/" class="normal" title="Restaurants" shape="rect"><xsl:text>Restaurants</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>University library</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/students/study/university-library/" class="normal" title="University library for students" shape="rect"><xsl:text>For students</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/university-library/" class="normal" title="University library for visitors" shape="rect"><xsl:text>For visitors</xsl:text></a></li><li/></ul><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>About Tilburg University</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Profile Tilburg University</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/about/" class="normal" title="About Tilburg University" shape="rect"><xsl:text>Facts and figures</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/rankings/" class="normal" title="Rankings" shape="rect"><xsl:text>Rankings</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/profile/quality-first/" class="normal" title="Quality first" shape="rect"><xsl:text>Quality first</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/profile/social-innovation/" class="normal" title="Social Innovation" shape="rect"><xsl:text>Social Innovation</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/profile/sustainability/" class="normal" title="Sustainability" shape="rect"><xsl:text>Sustainability</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/profile/international/" class="normal" title="Focus on international cooperation" shape="rect"><xsl:text>International cooperation</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/profile/conduct-integrity/" class="normal" title="Conduct and integrity" shape="rect"><xsl:text>Conduct and integrity</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/history/" class="normal" title="History" shape="rect"><xsl:text>History</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Organization</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/about/organisation-and-management/board/" class="normal" title="Executive Board" shape="rect"><xsl:text>Executive Board</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/organisation-and-management/governors/" class="normal" title="Board of Governors" shape="rect"><xsl:text>Board of Governors</xsl:text></a></li><li><xsl:text>Research Institutes</xsl:text></li><li><a href="//www.tilburguniversity.edu/about/organisation-and-management/service-departments/" class="normal" title="Management Services" shape="rect"><xsl:text>Services</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Schools</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/about/schools/economics-and-management/" class="normal" title="School of Economics and Management" shape="rect"><xsl:text>Tilburg School of Economics and Management</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/schools/law/" class="normal" title="Tilburg Law School" shape="rect"><xsl:text>Tilburg Law School</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/schools/socialsciences/" class="normal" title="Tilburg School of Social and Behavioral Sciences" shape="rect"><xsl:text>Tilburg School of Social and Behavioral Sciences</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/schools/humanities/" class="normal" title="Tilburg School of Humanities" shape="rect"><xsl:text>Tilburg School of Humanities</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/schools/theology/" class="normal" title="Tilburg School of Catholic Theology" shape="rect"><xsl:text>Tilburg School of Catholic Theology</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li><li class="dropdown yamm-fw"><a href="#" className="dropdown-toggle" data-toggle="dropdown" shape="rect"><xsl:text>Alumni</xsl:text></a><xsl:text> </xsl:text><ul class="dropdown-menu"><li class="grid-li col-md-3 padding-reset padding-right10"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><xsl:text>Alumni</xsl:text></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/alumni/" class="normal" title="Alumni" shape="rect"><xsl:text>Alumni homepage</xsl:text></a></li></ul><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><a href="//www.tilburguniversity.edu/alumni/stay-informed/" class="normal" title="Stay informed" shape="rect"><xsl:text>Stay informed</xsl:text></a></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/alumni/stay-informed/events/" class="normal" title="Events" shape="rect"><xsl:text>Events</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/stay-informed/until/" class="normal" title="Alumnimagazine Until" shape="rect"><xsl:text>Alumni Magazine</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/stay-informed/Newsletter/" class="normal" title="Newsletter" shape="rect"><xsl:text>Newsletter</xsl:text></a></li></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><a href="//www.tilburguniversity.edu/alumni/alumni-network/" class="normal" title="Your alumni network" shape="rect"><xsl:text>Your alumni network</xsl:text></a></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/alumni/alumni-network/chapters-and-associations/" class="normal" title="Alumni chapters and associations" shape="rect"><xsl:text>Chapters and associations</xsl:text></a></li><li><a href="https://www.linkedin.com/groups?gid=1777687&amp;trk=my_groups-b-grp-v" class="normal" title="https://www.linkedin.com/groups?gid=1777687&amp;trk=my_groups-b-grp-v" shape="rect"><xsl:text>LinkedIn</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/alumni-network/friends/" class="normal" title="Friends of Cobbenhagen" shape="rect"><xsl:text>Friends of Cobbenhagen</xsl:text></a></li><li/></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><a href="//www.tilburguniversity.edu/alumni/lifelong-learning/" class="normal" title="Lifelong learning" shape="rect"><xsl:text>Lifelong learning</xsl:text></a></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/education/post-experience-programs/" class="normal" title="Post-experience programs" shape="rect"><xsl:text>Post academisch onderwijs</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/lifelong-learning/attend-courses/" class="normal" title="Attend courses" shape="rect"><xsl:text>Attend Courses</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/graduated/vouchers/" class="normal" title="Knowledge vouchers for alumni" shape="rect"><xsl:text>Knowledge Vouchers</xsl:text></a></li><li/></ul><xsl:text> </xsl:text></li><li class="grid-li col-md-3"><xsl:text> </xsl:text><xsl:comment> normal render </xsl:comment><xsl:text> </xsl:text><h3 class="theme-blue-third-subsubtitle"><a href="//www.tilburguniversity.edu/alumni/How-can-I-stay-involved/" class="normal" title="How can I stay involved?" shape="rect"><xsl:text>Stay involved</xsl:text></a></h3><xsl:text> </xsl:text><ul class="theme-menu-bottom"><li><a href="//www.tilburguniversity.edu/alumni/How-can-I-stay-involved/donation/" class="normal" title="Make a donation" shape="rect"><xsl:text>Make a donation</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/alumni/How-can-I-stay-involved/Help-students/" class="normal" title="Help students" shape="rect"><xsl:text>Help students</xsl:text></a></li><li/></ul><xsl:text> </xsl:text></li></ul><xsl:text> </xsl:text></li></ul><div class="search nav navbar-nav navbar-right"><xsl:comment> normal render </xsl:comment><div class="search" style="border:medium none; float:right; height:30px; width:225px;"><div style="margin: 3px 0px 0px 4px;  padding: 4px 5px 4px 10px;"><fieldset style="border: none;"><xsl:text> </xsl:text><form action="//www.tilburguniversity.edu/searchresults2/" id="cse-search-box" method="get" enctype="application/x-www-form-urlencoded"><xsl:text> </xsl:text><input type="hidden" name="cx" value="014057647483100181293:-a7dtq4_q64"/><xsl:text> </xsl:text><input type="hidden" name="cof" value="FORID:10"/><xsl:text> </xsl:text><input type="hidden" name="ie" value="UTF-8"/><xsl:text> </xsl:text><input type="text" onfocus="clearMe(this)" value="Search our site" name="q" size="20" style="border: 1px solid rgb(51, 153, 0); padding: 0px; width: 155px; height: 21px; color: rgb(51, 153, 0); font-size: 12px;"/><xsl:text> </xsl:text><label class="hidden"><xsl:text>Vul uw zoekterm(en) in</xsl:text></label><xsl:text> </xsl:text><input type="submit" class="searchSubmit" style="margin: 0 0 0 0; float: none;" value=""/><xsl:text> </xsl:text></form><xsl:text> </xsl:text></fieldset><script type="text/javascript" src="//www.tilburguniversity.edu/static/uvtpresentation/js/google_local.js?form=cse-search-box&amp;lang=en" xml:space="preserve"/></div></div></div></div></div></div></div><div id="header"><div id="headerContent"><div id="logo"><a href="//www.tilburguniversity.edu/" class="navigation" title="" shape="rect"><img src="//www.tilburguniversity.edu/static/uvtpresentation/images/framework/logo.jpg" alt=""/></a></div><div id="payoff"><a href="//www.tilburguniversity.edu/about/profile/" class="navigation" title="" shape="rect"><img src="//www.tilburguniversity.edu/static/uvtpresentation/images/framework/understanding-society.jpg" alt=""/></a></div><div id="meta"><ul><li><a href="//www.tilburguniversity.edu/intranet/" class="mainNav" title="Intranet" shape="rect"><xsl:text>Intranet</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/students/" class="mainNav" title="Students" shape="rect"><xsl:text>Students</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/contact/" class="mainNav" title="Contact" shape="rect"><xsl:text>Contact</xsl:text></a></li><li><a href="//www.tilburguniversity.edu/about/working-at/" class="mainNav" title="Working at" shape="rect"><xsl:text>Working at</xsl:text></a></li><li><a href="#" class="mainNav lastItem" rel="nofollow" onclick="PrintElem('#content')" shape="rect"><img src="//www.tilburguniversity.edu/static/uvtpresentation/images/content/print.png" alt="Print"/><span><xsl:text> </xsl:text></span></a></li></ul></div><xsl:apply-templates select="ss:languages"/></div></div><xsl:if test="../ss:big-brother"><script type="text/javascript" xml:space="preserve"><xsl:comment>
	(function() {
		var ga = document.createElement('script');
		ga.type = 'text/javascript';
		ga.async = true;
		ga.src = ('https:'   == document.location.protocol ? 'https://ssl'   : 'http://www') + '.google-analytics.com/ga.js';
		var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();
	$(document).ready(function() {
		// downloads
		$("a[href*='/file?']").attr("onClick", "_qaq.push(['_trackPageview', this.href, 'clicked']);");
		// external links
		$("a[href*='http']").not("a[href*='www.tilburguniversity.edu']").not("a[href*='edit.tilburguniversity.edu']")
			.each(function(i,link) {
				var link = $(this);
				if (this.onclick == undefined || this.onclick == null) {
					link.attr("onClick","_qaq.push(['_trackPageview', this.href, 'clicked'])");
				} else {
					link.bind('click',function() {
						_qaq.push(['_trackPageview', this.href, 'clicked']);
					});
				}
		});
	});
//</xsl:comment></script></xsl:if></body></html></xsl:template><xsl:template match="ss:navbar"><div id="menuContainer"><ul><xsl:apply-templates select="ss:nav"/></ul></div></xsl:template><xsl:template match="ss:nav[ss:nav]"><li class="visitedPage"><a href="{ss:link}"><xsl:apply-templates select="ss:message/node()" mode="verbatim"/></a></li><xsl:apply-templates select="ss:nav"/></xsl:template><xsl:template match="ss:nav[@current]"><li class="currentPage"><a href="{ss:link}"><xsl:apply-templates select="ss:message/node()" mode="verbatim"/></a></li><xsl:apply-templates select="ss:nav"/></xsl:template><xsl:template match="ss:nav"><li class="rowBg"><a href="{ss:link}"><xsl:apply-templates select="ss:message/node()" mode="verbatim"/></a></li></xsl:template><xsl:template match="ss:content"><xsl:apply-templates select="node()" mode="verbatim"/></xsl:template><xsl:template match="ss:sidebar[node()]"><div id="sidebar" class="clearfix"><xsl:apply-templates select="ss:content|ss:panel"/></div></xsl:template><xsl:template match="ss:sidebar/ss:content[last()]"><div class="block lastItem"><xsl:apply-templates select="node()" mode="verbatim"/></div></xsl:template><xsl:template match="ss:sidebar/ss:content[position() != last()]"><div class="block"><xsl:apply-templates select="node()" mode="verbatim"/></div></xsl:template><xsl:template match="ss:panels"><ul><xsl:apply-templates select="ss:panel"/></ul></xsl:template><xsl:template match="ss:panel"><li><a href="{ss:link}"><xsl:apply-templates select="ss:message/node()" mode="verbatim"/></a><span class="banner{ss:color}"/><img src="{ss:image}" alt="{ss:message}"/></li></xsl:template><xsl:template match="ss:languages"><div id="languages" class="navigationContent"><ul><li><xsl:text> </xsl:text><ul><li><a href="//www.tilburguniversity.edu/apps-nav-rightcol/"><xsl:attribute name="class" value="navigation"/><xsl:attribute name="title" value="Global / English"/><xsl:if test="../ss:big-brother"><xsl:attribute name="onclick" value="_gaq.push(['_trackEvent', '', 'click', 'languageswitch_google_analytics_current_lang']);"/></xsl:if><xsl:attribute name="shape" value="rect"/><xsl:attribute name="href"><xsl:apply-templates select="ss:language[ss:code='en']/ss:target"/></xsl:attribute><img src="//www.tilburguniversity.edu/static/uvtpresentation/images/framework/flags/EN.gif" alt="Global / English"/><xsl:text> Global / English</xsl:text></a></li></ul><xsl:text> </xsl:text><div class="switchLanguage"><a href="//www.tilburguniversity.edu/nl/apps-nav-rightcol/"><xsl:attribute name="class" value="navigation"/><xsl:attribute name="title" value="Nederlands"/><xsl:if test="../ss:big-brother"><xsl:attribute name="onclick" value="_gaq.push(['_trackEvent', '', 'click', 'languageswitch_google_analytics_naar_EN']);"/></xsl:if><xsl:attribute name="shape" value="rect"/><xsl:attribute name="href"><xsl:apply-templates select="ss:language[ss:code='nl']/ss:target"/></xsl:attribute><img src="//www.tilburguniversity.edu/static/uvtpresentation/images/framework/flags/NL.gif" alt="Nederlands"/><xsl:text> Nederlands</xsl:text></a></div><xsl:text> </xsl:text></li></ul></div></xsl:template><xsl:template match="@*|node()" mode="verbatim"><xsl:copy><xsl:apply-templates select="@*|node()" mode="verbatim"/></xsl:copy></xsl:template></xsl:stylesheet>
