# $Id: Document.pm 42155 2014-09-05 09:24:21Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Delete/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Person::Delete::Document;

use UvT::Kiki::WS::Person::Document -self;

sub build {
	my $req = $self->req;
	my $json = $self->json;
	my $old_person = $req->old_person;
	$json->{person} = $old_person
		if $old_person;
	$json->{note} = $req->note;
}

sub serialize {
	my $res = super;
	my $note = $self->req->note;
	my ($delete_result, $delete_why) = @$note;
	$res->status($delete_why eq 'no-robot' ? 403 : 422)
		if defined $delete_result && $delete_result eq 'error';
	return $res;
}
