# $Id: Request.pm 41846 2014-06-30 15:11:20Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Post/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Person::Post::Request;

use JSON;

use UvT::Kiki::WS::Person::Request -self;

field notes => {name => '', domain => '', destinations => []};

field request_data => sub {
	my $self = shift;
	my $type = $self->content_type;
	die "Unsupported request content type '$type' (expected application/json)\n"
		if $type ne 'application/json';
	return decode_json($self->request_body->bodyhandle->as_string);
};

field new_person => sub {
	my $self = shift;
	my $person = super;

	if($self->nonce) {
		my $db = $self->db;
		my $address = $self->address;
		my $data = $self->request_data;
		my $notes = $self->notes;

		if($alias->type eq 'alias') {
			$notes->{update} = [error => 'alias'];
			return $person;
		}

		my @names = map { trim($_) } @{$data->{names}};

		$notes->{names} = $alias->update_names(\@names);
		$notes->{domain} = $alias->update_domain($data->{domain});
		$notes->{destination} = $alias->update_destination(trim($data->{name}));

		if(grep { $_->[0] eq 'error' } @{$notes->{names}}, $notes->{domain}, $notes->{destination}) {
			$notes->{update} = ['error'];
		} else {
			if($alias->unique) {
				my $who = $self->login;
				my $new = $person->toString;
				if(my $original = $person->original) {
					my $name = $original->full;
					my $old = $person->original->toString;
					my $text = "User $who updated person:\n\told: $old\n\tnew: $new\n";
					warn $text;
					$self->mailtje("[kiki] $who updated $name", $text);
				} else {
					my $name = $person->full;
					my $text = "User $who created person:\n\tnew: $new\n";
					warn $text;
					$self->mailtje("[kiki] $who created $name", $text);
				}

				$person->store;
				$self->activate;
				$notes->{update} = [ok => 'stored'];
			} else {
				$notes->{update} = [error => 'person-exists'];
			}
		}
	} else {
		$self->notes({update => [error => 'session']});
	}

	return $alias;
};
