// $Id: xml.js 37185 2012-06-13 15:01:03Z wsl $

function xml() {
	return xml.serialize(xml.construct.apply(xml, arguments));
}

xml.construct = xml.construct_xml = function() {
	var doc = window.ActiveXObject
		? new ActiveXObject('MSXML2.DOMDocument')
		: document.implementation.createDocument(null, null, null);
	doc.appendChild(this.construct_generic(doc, arguments));
	return doc;
};

xml.construct_xhtml = xml.construct_html = function() {
	return this.construct_generic(document, arguments);
};

xml.isArray = Array.isArray || function(a) {
	return Object.prototype.toString.call(a) == '[object Array]';
};

xml.construct_generic = function(doc, x) {
	var e = doc.createElement(x[0]);
	for(var i = 1; i < x.length; i++) {
		var a = x[i];
		var t = typeof(a);
		if(t == 'object') {
			if(xml.isArray(a)) {
				e.appendChild(this.construct_generic(doc, a));
			} else if(a.each) {
				a.each(function(i, n) { e.appendChild(n) });
			} else {
				try {
					e.appendChild(a);
				} catch(exc) {
					for(var k in a)
						e.setAttribute(k, a[k]);
				}
			}
		} else {
			e.appendChild(doc.createTextNode(a));
		}
	}
	return e;
};

function html() {
	return xml.construct_html.apply(xml, arguments);
}

html.construct = function() {
	return xml.construct_html.apply(xml, arguments);
};

xml.serialize = function(dom) {
	if(window.ActiveXObject) // IE
		return dom.xml;
	return new XMLSerializer().serializeToString(dom);
};
