use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::ReST::Request;

use Xyzzy::Directory;
use Xyzzy::Directory::Request -self;

field pairs => sub {
	my $self = shift;
	my @res = @{(eval { super } // [])};
	my $path = $self->path_components;
	if(@$path) {
		push @res, shift @$path;
		push @res, shift @$path;
	}
	return \@res;
};

package Xyzzy::ReST;

use Xyzzy::Handler -self;

use Xyzzy::Fail;

field generic => {};
field specific => {};
field fallback => sub { new Xyzzy::Fail(cfg => shift, code => 404) };

sub handle {
	my $req = new Xyzzy::ReST::Request(cfg => $self, ctx => shift);

	my $path = $req->path_components;

	return $self->handler->handle($req, @_)
		unless @$path;

	my $pairs = $req->pairs;

	my $entity = $pairs->[-2];
	my $value = $pairs->[-1];

	my $handlers = defined $value ? $self->specific : $self->generic;

	my $handler = $handlers->{$entity};
	return $self->fallback->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
