/******************************************************************************

	conf.h -- handle the configuration file
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: conf.h 6337 2004-11-26 14:48:00Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/conf.h $

******************************************************************************/
#ifndef CONF_H
#define CONF_H

#include <regex.h>

#include <avl.h>

#include "chrono.h"

typedef struct option_t {
	avl_node_t node;
	bool (*set)(const char *s, bool);
	char name[1];
} option_t;

extern bool conf_load(const char *, bool);
extern bool conf_reload(const char *);

#undef _StringConfigVal
#undef _BoolConfigVal
#undef _StampConfigVal
#undef _SizeConfigVal
#undef _RegexConfigVal
#define _StringConfigVal(s,d) extern const char *conf_##s;
#define _BoolConfigVal(b,d) extern bool conf_##b;
#define _StampConfigVal(t,d) extern stamp_t conf_##t;
#define _SizeConfigVal(s,d) extern size_t conf_##s;
#define _RegexConfigVal(r,d) extern regex_t *conf_##r;

#include "options.h"

#undef _StringConfigVal
#undef _BoolConfigVal
#undef _StampConfigVal
#undef _SizeConfigVal
#undef _RegexConfigVal

#endif
