/******************************************************************************

	fdcopy.h -- ringbuffer copying routines
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: fdcopy.h 6337 2004-11-26 14:48:00Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair/src/fdcopy.h $

******************************************************************************/

#ifndef FDCOPY_H
#define FDCOPY_H

#include <sys/select.h>
#include <avl.h>

#include "fd.h"

typedef enum {
	FDCOPY_EVENT_READ,
	FDCOPY_EVENT_WRITE,
	FDCOPY_EVENT_DONE
} fdcopy_event_t;

struct fdcopy;

typedef void (*fdcopy_hook_t)(struct fdcopy *, fdcopy_event_t, int);

typedef struct fdcopy {
	avl_node_t node;
	fd_t *src, *dst;
	size_t size, fill, offset;
	fdcopy_hook_t func;
	void *data;
	byte buf[1];
} fdcopy_t;

extern unsigned int fdcopy_count(void);
extern size_t fdcopy_bufsize(size_t);
extern size_t fdcopy_minsize(size_t);
extern fdcopy_t *fdcopy_new(fd_t *, fd_t *, fdcopy_hook_t, void *);
extern void fdcopy_delete(fdcopy_t *);

#endif
