# $Id: Loandesk.pm 32956 2010-11-05 10:51:54Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::Resources;

use UvT::Loandesk::LDAP;
use UvT::Loandesk::MPS;
use UvT::Loandesk::Aselect;
use UvT::Loandesk::AuthBroker;
use UvT::Loandesk::Crypto;

use UvT::Loandesk::Handler -self;

field dir => sub { new UvT::Loandesk::LDAP(cfg => shift->cfg) };
field mps => sub { new UvT::Loandesk::MPS(cfg => shift->cfg) };
field aselect => sub { new UvT::Loandesk::Aselect(cfg => shift->cfg) };
field authbroker => sub { new UvT::Loandesk::AuthBroker(cfg => shift->cfg) };
field crypto => sub { new UvT::Loandesk::Crypto(cfg => shift->cfg) };

package UvT::Loandesk;

use Xyzzy::Directory;
use UvT::Loandesk::Root;
use UvT::Loandesk::Mainpage;
use UvT::Loandesk::Gimme;
use UvT::Loandesk::GoBack;
use UvT::Loandesk::SendRequest;
use UvT::Loandesk::Form;

use Xyzzy -self;

use UvT::Loandesk::Config -mixin;
use UvT::Loandesk::MPS::Config -mixin;
use UvT::Loandesk::LDAP::Config -mixin;
use UvT::Loandesk::Aselect::Config -mixin;
use UvT::Loandesk::AuthBroker::Config -mixin;

sub handler {
	my $rsc = new UvT::Loandesk::Resources(cfg => $self);

	my @methods = (
		new UvT::Loandesk::GoBack(cfg => $rsc),
		new UvT::Loandesk::SendRequest(cfg => $rsc),
		new UvT::Loandesk::Form(cfg => $rsc),
	);

	return new UvT::Loandesk::Root(cfg => $rsc,
		handler => new Xyzzy::Directory(cfg => $rsc,
			handler => new UvT::Loandesk::Mainpage(cfg => $rsc),
			subdirs => {
				list => new UvT::Loandesk::List(cfg => $rsc),
				reserve => new UvT::Loandesk::Reserve(cfg => $rsc, methods => \@methods),
				order => new UvT::Loandesk::Order(cfg => $rsc, methods => \@methods),
				free => new UvT::Loandesk::OrderFree(cfg => $rsc, methods => \@methods),
			}
		)
	);
}
