# $Id: Document.pm 32558 2010-09-23 13:27:12Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::Document;

use Xyzzy::Document::Styled -self;

sub addTemplates {
	my $lang = $self->req->lang;
	return super(map { "$lang/$_" } @_);
}

sub getFragment {
	my $lang = $self->req->lang;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub dumpreq {
	my $req = $self->req;
	while($req) {
		my $c = eval { $req->organizationcookie };
		$c = defined $c ? "'$c'" : 'undef';
		warn "organizationcookie=$c ($req)";
		$req = eval { $req->ctx };
	}
}

sub response {
	my $res = super;
	my $req = $self->req;

	if(my $session = $req->sessioncookie) {
		my $cookie = $self->bakecookie(session => $session);
		$res->setcookie($cookie);
	}
	if(my $organization = $req->organizationcookie) {
		my $cookie = $self->bakecookie(organization => $organization);
		$cookie->expire('1y');
		$res->setcookie($cookie);
	}
	if(my $aselect = $req->aselectcookie) {
		my $cookie = $self->bakecookie(aselect => $aselect);
		$res->setcookie($cookie);
	}
	if(my $authbroker = $req->authbrokercookie) {
		warn "Set-Cookie: authbroker=$authbroker";
		my $cookie = $self->bakecookie(authbroker => $authbroker);
		$res->setcookie($cookie);
	}

	return $res;
}
