# $Id: GoBack.pm 32470 2010-09-15 14:24:56Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/GoBack.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::GoBack::Document;

use UvT::Loandesk::Document -self;

sub response {
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setheader(Location => $self->req->back);
	return $res;
}

package UvT::Loandesk::GoBack::Request;

use UvT::Loandesk::Request -self;

param cancel;

package UvT::Loandesk::GoBack;

use UvT::Loandesk::Handler -self;

sub handle {
	my $req = new UvT::Loandesk::GoBack::Request(ctx => shift, cfg => $self);
	return unless $req->back && $req->cancel && $req->nonce;
	my $doc = new UvT::Loandesk::GoBack::Document(req => $req);
	return $doc->response;
}
