# $Id: Root.pm 33066 2010-11-18 15:32:46Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/loandesk/lib/UvT/Loandesk/Root.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Loandesk::AselectLogin;

use UvT::Loandesk::Document -self;

field url;
field msg => sub {};

sub build {
	my $msg = $self->msg;
	#$self->addTemplates($msg) if $msg;
}

sub response {
	my $res = super;
	$res->status(302);
	$res->setheader(Location => $self->url);
	return $res;
}

package UvT::Loandesk::Error;

use UvT::Loandesk::Document -self;

field type;
field msg;

sub build {
    $self->addTemplates('error');

    my $error_type = $self->getElementById('error_type');
    $error_type->appendText($self->type);

    my $error_msg = $self->getElementById('error_msg');
    $error_msg->appendText($self->msg);
}

package UvT::Loandesk::Root::Request;

use UvT::Loandesk::Request -self;

use UvT::Loandesk::Crypto;
use Aselect::Util;

field sessioncookie => undef;
field organizationcookie => undef;
field aselectcookie => undef;
field authbrokercookie => undef;

sub errorpage {
    my ($type, $msg) = @_;
	my $doc = new UvT::Loandesk::Error(req => $self, type => $type, msg => $msg);
	return $doc->response;
}

param back;

field lang => sub {
	my $self = shift;

	my $h = lc($self->http('Accept-Language'));
	$h =~ s/\s//g;

	my @supported = @{$self->cfg->languages};
	my %supported; @supported{@supported} = ();

	my $curlang = $supported[0] // 'en';
	my $curlevel = 0;

	foreach my $q (split(',', $h)) {
		my $level = 1;
		my ($lang, @attrs) = split(';', $q);
		$lang =~ s/-.*//;
		next unless exists $supported{$lang};
		foreach my $a (@attrs) {
			my ($key, $val) = split('=', $a, 2);
			$level = $val
				if $key eq 'q' && $val =~ /^\d+(?:\.\d+)$/;
		}
		if($level > $curlevel) {
			$curlang = $lang;
			$curlevel = $level;
		}
	}

	return $curlang;
};

sub aselect_login {
	my $cfg = $self->cfg;
	my $aselect = $cfg->aselect;

	if(my $ticket = $self->cookie('aselect')) {
		my ($uid, $org) = eval { $aselect->verify_ticket($ticket) };
		return $uid unless $@;
		warn "aselect_verify_ticket: $@";
	}

	$self->param(nonce => $self->nonce);
	my $url = $self->self_url;

	if(my $cred = $self->param('aselect_credentials')) {
		my $rid = $self->param('rid');
		die "no rid param\n" unless defined $rid;
		my $ticket = eval { $aselect->verify_credentials($rid, $cred) };
		if($@) {
			die $self->errorpage('System error', 'A-Select login failed');
		} else {
			$self->aselectcookie($ticket);
			my $doc = new UvT::Loandesk::AselectLogin(req => $self, url => $url, msg => 'aselect_complete');
			die $doc->response;
		};
	}

	my $sso = $aselect->authenticate($url);
	my $doc = new UvT::Loandesk::AselectLogin(req => $self, url => $sso, msg => 'aselect_start');
	die $doc->response;
}

sub authbroker_login {
	return $self->{authbroker} if exists $self->{authbroker};
	undef $self->{authbroker};

	my $cfg = $self->cfg;
	my $secret = $cfg->secret;
	my $authbroker = $cfg->authbroker;

	my $cookie = $self->cookie('authbroker');
	if($cookie) {
		my (undef, undef, $uid) = eval { $self->crypto->check_token('e', $cookie, $cfg->authbroker_expiry) };
		return $self->{authbroker} = $uid if $uid;
	}

	my $uid = $self->userid;

	return unless $authbroker->authbroker($uid, $self->password);

	my $session = $self->crypto->create_token('e'.$secret, $uid);
	$self->authbrokercookie($session);

	return $self->{authbroker} = $uid;
}

const anr => sub {
	my $self = shift;
	my $org = $self->organization or return undef;
	$org = lc($org);

	my $anr;
	if($org eq 'uvt') {
		my $uid = $self->aselect_login;
		$anr = $self->dir->anr($uid);
	} elsif($org eq 'extusr')  {
		$anr = $self->authbroker_login;
	} else {
		die $self->errorpage('Application error', "unknown organization '$org'");
	}
	return $anr;
};

const have_anr => sub {
	return scalar eval { shift->anr };
};

param organization => sub {
	my $self = shift;
	if($_) {
		die $self->errorpage('Application error', 'organization parameter not valid')
			if /\W/;
		$self->organizationcookie($_);
	} else {
		$_ = $self->cookie('organization');
		undef $_ if defined && /\W/;
	}
};

const session => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $cfg->crypto;

	my $salt;
	eval {
		my $session = $self->cookie('session');
		(undef, $salt) = $crypto->check_token('s', $session);

		my $nonce = $self->param('nonce');
		$crypto->check_token('n'.$salt, $nonce, $cfg->nonce_expiry);
		$self->{nonce} = $nonce;
	};
#	warn $@ if $@;

	unless(defined $salt) {
		(undef, $salt, my $session) = $crypto->create_token('s', '');
		$self->sessioncookie($session);
	}

	return $salt;
};

const nonce => sub {
	# figuring out and checking the nonce is a side-effect of session():
	shift->session;
	return;
};

const title => sub {
	my $self = shift;
	my $title = $self->mps->gettitle($self->epn)
		or die $self->errorpage('Error', 'Unknown publication');
	return $title;
};

param epn => sub {
	my $self = shift;
	die $self->errorpage('Application error', 'epn parameter missing')
		unless $_;
	die $self->errorpage('Application error', 'epn parameter not valid')
		if /\W/;
};

param volumeid => sub {
	my $self = shift;
	die $self->errorpage('Application error', 'volumeid parameter missing')
		unless $_;
	die $self->errorpage('Application error', 'volumeid parameter not valid')
		if /\W/;
};

param ophaaltype => sub {
	die shift->errorpage('Application error', 'ophaaltype parameter not valid')
		if defined && /\W/;
};

param submit => sub {
	$_ = defined;
};

package UvT::Loandesk::Root;

use UvT::Loandesk::Handler -self;

sub handle {
	local $SIG{__DIE__} = sub {
		die(@_) if ref $_[0]
			|| join('', @_) =~ /called at [^\n]* line \d+/;
		confess(@_);
	};
	my $req = new UvT::Loandesk::Root::Request(cfg => $self, ctx => shift);
	return $self->handler->handle($req);
}
