# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-03-07 08:49
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('autodidact', '0014_auto_20160224_1544'),
    ]

    operations = [
        migrations.AddField(
            model_name='class',
            name='teacher',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='teaches', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='assignment',
            name='active',
            field=models.BooleanField(default=True, help_text='Inactive assignments are not visible to students'),
        ),
        migrations.AlterField(
            model_name='assignment',
            name='locked',
            field=models.BooleanField(default=True, help_text='Locked assignments can only be made by students in class'),
        ),
        migrations.AlterField(
            model_name='clarification',
            name='description',
            field=models.TextField(help_text='This field supports <a target="_blank" href="http://daringfireball.net/projects/markdown/syntax">Markdown syntax</a>'),
        ),
        migrations.AlterField(
            model_name='course',
            name='active',
            field=models.BooleanField(default=True, help_text='Inactive courses are not visible to students'),
        ),
        migrations.AlterField(
            model_name='course',
            name='description',
            field=models.TextField(help_text='This field supports <a target="_blank" href="http://daringfireball.net/projects/markdown/syntax">Markdown syntax</a>'),
        ),
        migrations.AlterField(
            model_name='presentation',
            name='visibility',
            field=models.IntegerField(choices=[(1, 'Only visible to teacher'), (2, 'Visible to students in class'), (3, 'Visible to everyone')]),
        ),
        migrations.AlterField(
            model_name='session',
            name='active',
            field=models.BooleanField(default=True, help_text='Inactive sessions are not visible to students'),
        ),
        migrations.AlterField(
            model_name='session',
            name='description',
            field=models.TextField(help_text='This field supports <a target="_blank" href="http://daringfireball.net/projects/markdown/syntax">Markdown syntax</a>'),
        ),
        migrations.AlterField(
            model_name='session',
            name='registration_enabled',
            field=models.BooleanField(default=True, help_text='When enabled, class attendance will be registered'),
        ),
        migrations.AlterField(
            model_name='step',
            name='answer_required',
            field=models.BooleanField(default=False, help_text='If enabled, this step will show the student a text box where they can enter their answer'),
        ),
        migrations.AlterField(
            model_name='step',
            name='description',
            field=models.TextField(help_text='This field supports <a target="_blank" href="http://daringfireball.net/projects/markdown/syntax">Markdown syntax</a>'),
        ),
    ]
