import bleach
import subprocess

ATTRIBUTES = {
    '*': ['class', 'style'],
    'a': ['href', 'rel', 'download'],
    'img': ['src', 'alt'],
    'table': ['border'],

    # These attributes are useful for embedded Youtube video's
    'iframe': ['width', 'height', 'src', 'frameborder', 'allowfullscreen'],
}

TAGS = [
    'a',
    'abbr',
    'acronym',
    'address',
#    'applet',
    'area',
    'article',
    'aside',
#    'audio',
    'b',
    'base',
    'basefont',
    'bdi',
    'bdo',
    'big',
    'blockquote',
    'body',
    'br',
#    'button',
#    'canvas',
    'caption',
    'center',
    'cite',
    'code',
    'col',
    'colgroup',
    'datalist',
    'dd',
    'del',
    'details',
    'dfn',
#    'dialog',
    'dir',
    'div',
    'dl',
    'dt',
    'em',
    'embed',
    'fieldset',
    'figcaption',
    'figure',
    'font',
    'footer',
    'form',
#    'frame',
#    'frameset',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'head',
    'header',
    'hr',
    'html',
    'i',
    'iframe',
    'img',
    'input',
    'ins',
    'kbd',
    'keygen',
    'label',
    'legend',
    'li',
    'link',
    'main',
    'map',
    'mark',
    'menu',
    'menuitem',
    'meta',
    'meter',
    'nav',
#    'noframes',
    'noscript',
    'object',
    'ol',
    'optgroup',
    'option',
    'output',
    'p',
    'param',
    'pre',
    'progress',
    'q',
    'rp',
    'rt',
    'ruby',
    's',
    'samp',
#    'script',
    'section',
    'select',
    'small',
    'source',
    'span',
    'strike',
    'strong',
    'style',
    'sub',
    'summary',
    'sup',
    'table',
    'tbody',
    'td',
    'textarea',
    'tfoot',
    'th',
    'thead',
    'time',
    'title',
    'tr',
    'track',
    'tt',
    'u',
    'ul',
    'var',
    'video',
    'wbr',
]

STYLES = [
    'background',
    'background-attachment',
    'background-color',
#    'background-image',
    'background-position',
    'background-repeat',
    'border',
    'border-bottom',
    'border-bottom-color',
    'border-bottom-style',
    'border-bottom-width',
    'border-color',
    'border-left',
    'border-left-color',
    'border-left-style',
    'border-left-width',
    'border-right',
    'border-right-color',
    'border-right-style',
    'border-right-width',
    'border-style',
    'border-top',
    'border-top-color',
    'border-top-style',
    'border-top-width',
    'border-width',
    'clear',
    'clip',
    'color',
    'cursor',
    'display',
    'filter',
    'font',
    'font-family',
    'font-size',
    'font-variant',
    'font-weight',
    'height',
    'left',
    'letter-spacing',
    'line-height',
    'list-style',
#    'list-style-image',
    'list-style-position',
    'list-style-type',
    'margin',
    'margin-bottom',
    'margin-left',
    'margin-right',
    'margin-top',
    'overflow',
    'padding',
    'padding-bottom',
    'padding-left',
    'padding-right',
    'padding-top',
    'page-break-after',
    'page-break-before',
    'position',
    'float',
    'text-align',
    'text-decoration',
    'text-decoration: blink',
    'text-decoration: line-through',
    'text-decoration: none',
    'text-decoration: overline',
    'text-decoration: underline',
    'text-indent',
    'text-transform',
    'top',
    'vertical-align',
    'visibility',
    'width',
    'z-index',
]

def pandoc(source):
    p = subprocess.Popen(['pandoc', '--smart', '--mathjax', '--email-obfuscation=none'],
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    )

    # something else than 'None' indicates that the process already terminated
    if not (p.returncode is None):
        raise RuntimeError('Pandoc died with exitcode {} before receiving input: {}'.format(p.returncode, p.stderr.read()))

    try:
        source = source.encode('utf-8')
    except UnicodeEncodeError:
        # assume that it is already a utf-8 encoded string
        pass

    stdout, stderr = p.communicate(source)

    try:
        stdout = stdout.decode('utf-8')
    except UnicodeDecodeError:
        raise RuntimeError('Pandoc output was not utf-8. Weird.')

    if p.returncode != 0:
        raise RuntimeError('Pandoc died with exitcode {} during conversion: {}'.format(p.returncode, stderr))

    return bleach.clean(
        stdout,
        tags = TAGS,
        attributes = ATTRIBUTES,
        styles = STYLES,
    ) + '<script src="https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML" type="text/javascript"></script>'
