#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';
use autodie;

use Test::More;
use File::Temp;

my $tmp = File::Temp->newdir;

BEGIN { use_ok('File::Hashset') or BAIL_OUT('need File::Hashset package to run') }

my $testfile1 = "$tmp/test1";

open my $fh1, '>', $testfile1;

for(my $i = 0; $i < 256; $i++) {
	print $fh1 chr($i)x32;
}

for(my $i = 0; $i < 256; $i++) {
	print $fh1 chr($i)x32;
}

for(my $i = 0; $i < 256; $i++) {
	print $fh1 ('A'x8 . chr($i)x24);
}

close $fh1;

File::Hashset->sortfile($testfile1, 32);

my $a = File::Hashset->load($testfile1, 32);

for(my $i = 0; $i < 256; $i++) {
	ok($a->exists(chr($i)x32), "chr($i)x32 should exist");
}

for(my $i = 0; $i < 256; $i++) {
	ok($a->exists('A'x8 . chr($i)x24), "'A'x8 . chr($i)x24 should exist");
}

ok(!$a->exists('AB'x16), "ABAB...AB should not exist");

my $n = 0;
my $i = $a->iterator;
while(my $k = $i->fetch) {
	$n++;
}

is($n, 511, "iterating should yield 511 entries");

undef $a;
undef $i;

my $testfile2 = "$tmp/test2";

open my $fh2, '>', $testfile2;

for(my $i = 0; $i < 256; $i++) {
	for(my $j = 0; $j < 256; $j++) {
		print $fh2 (chr($i)x8) . (chr($j)x24);
	}
}

close $fh2;

my $b = File::Hashset->load($testfile2, 32);

for(my $i = 0; $i < 256; $i++) {
	for(my $j = 0; $j < 256; $j++) {
		ok($b->exists(chr($i)x8 . chr($j)x24), "chr($i)x8 . chr($j)x24 should exist");
	}
}

ok(!$b->exists('AB'x16), "ABAB should not exist");

undef $b;

my $testfile3 = "$tmp/test3";

my @sources = map { File::Hashset->load($_, 32) } (($testfile1, $testfile2) x 500);

File::Hashset->merge($testfile3, @sources);

my $c = File::Hashset->load($testfile3, 32);

for(my $i = 0; $i < 256; $i++) {
	for(my $j = 0; $j < 256; $j++) {
		ok($c->exists(chr($i)x8 . chr($j)x24), "chr($i)x8 . chr($j)x24 should exist");
	}
}

ok(!$c->exists('AB'x16), "ABAB should not exist");

@sources = ();

undef $c;

my $testfile4 = "$tmp/test4";

open my $fh4, '>', $testfile4;
close $fh4;

File::Hashset->sortfile($testfile4, 32);

my $d = File::Hashset->load($testfile4, 32);

ok(!$d->exists('AB'x16), "ABAB should not exist");

my $e = File::Hashset->new('', 32);
my $f = File::Hashset->new('A'x32, 32);

ok(!$e->exists('AB'x16), "ABAB should not exist");

my $testfile5 = "$tmp/test5";

File::Hashset->merge($testfile5, 32, $d, $e, $f);

undef $d;
undef $e;
undef $f;

done_testing();
