/*
	$URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/gatekeeper/src/main.js $
	$Id: main.js 42965 2015-02-23 12:59:08Z anton $
 */

var cf;
var feedbackTypeWindow;
var feedbackMessageWindow;

function toggleEl(el) {
	el.style.display = (el.style.display != 'none'?'none' : '' ) ;
}

function toggle(id) {
	var el = ID(id);
    if (el)
		toggleEl(el);
}

function toggleClearText () {
	/*	IE  cannot change the .type attribute.
		IE8 can clone nodes, IE7 cannot.
		Add an extra inputfield and toggle visibility :(

		N.B. The cursusposition in IE is lost after focus(), not so in firefox.
	*/

	var pwd = ID('pleaseAnswer');
	var clr = ID('pleaseAnswerClr');
	if (pwd == null || clr == null) return false;

	toggleEl(clr);
	toggleEl(pwd);

	if (this.checked) {
		clr.value = pwd.value;
		clr.focus();
	} else {
		pwd.value = clr.value;
		pwd.focus();
	}
	return true;
}

function mixAnswers (){
	var check = ID('switchDisplayText');
	var pwd = ID('pleaseAnswer');
	var clr	= ID('pleaseAnswerClr');

	if (check != null && check.checked)
			pwd.value = clr.value;

	thanksForAllTheFish();
}


function err(msg) {
	setTimeout(function() { throw new Error(msg); }, 0);
	return false;
}

function eraseFeedback(msg, newmsg){
	if (document.getElementById('txtFeedbackMessage').innerHTML == msg)
		success(newmsg);
}

function feedback(msg) {
	document.getElementById('txtFeedbackMessage').innerHTML = msg;
}

function userError(msg) {
	document.getElementById('feedbackFieldset').className = "userError";
	document.getElementById('feedbackColumnLeft').className = "feedbackColumnLeft-userError";
	feedback(msg);
	return false;
}

function userAlert(msg) {
	document.getElementById('feedbackFieldset').className = "userAlert";
	document.getElementById('feedbackColumnLeft').className = "feedbackColumnLeft-userAlert";
	feedback(msg);
	return false;
}


function success(msg) {
	document.getElementById('feedbackFieldset').className = "success";
	document.getElementById('feedbackColumnLeft').className = "feedbackColumnLeft-success";
	feedback(msg)
	return true;
}

function thanksForAllTheFish() {
	return success(cf['loading']);
}

function silentID(id) {
	var res = document.getElementById(id);

 	if (typeof(id) == undefined || res == null) {
		return null;
	}
	return res;
}

function ID(id) {
	var res = silentID(id);
	return res;

// IE fails on err
	if (res == null)
		err('Element not found: ' + id);
	return res;
}

function setFocus(id) {
		var res = ID(id);
		if (res)
			res.focus();
	return res;
}

function setLiveCheck(id, fun) {
	var res = ID (id);
 	if (res) {
		res.onkeyup  = fun;
		res.onchange  = fun;
	}
	return res;
}

var focusFound = false;
function focusFirstEmptyInputfield(id) {
	var form = ID(id);
	if (form == null)
		return ;

	for (var i = 0; i < form.elements.length; i++ ) {
		var element = form.elements[i];
		if (element.nodeName == 'INPUT'  &&
			(element.type == 'text'||element.type == 'password') &&
			element.disabled == false &&
			element.value == "" ) {
					element.focus();
					focusFound = true;
					return true;
			}
	}
	return false;
}

function fallbackFocus (id) {
	if (!focusFound) {
		var f = silentID('password');
		if (f) {
			f.focus();
			focusFound = true;
		}
	}
}



window.onload = function() {
    // readJavascriptConfig() wordt gedefiniëerd in gatekeeper.template!
	// mag pas aangeroepen worden in window.onload
	cf = readJavascriptConfig();
	var action = cf['action'];

/*
mogelijke acties:
	changeQAM
	setPassword
	answerQuestions
	showAccountSettings
	changePassword
	changeTemporaryPassword2
	changeTemporaryPassword
	supervisedSetPassword
	mailChallenge
*/
	var formId = 'baseform';
	var form = silentID(formId);
	if (form == null)
		return false;

	// Set onsubmit for all the actions
	form.onsubmit = thanksForAllTheFish;

	// Set onsubmit for some specific actions
	var afs = {};
	afs['changePassword'] = afs['setPassword'] = checkPwdSubmit;
	afs['changeQAM'] = checkQAM;

	if (afs[action])
		form.onsubmit = afs[action];

 	focusFirstEmptyInputfield(formId);
	fallbackFocus('password');

	// Action specific stuff
	switch (action) {
		case 'changeTemporaryPassword':
		case 'changeTemporaryPassword2':
			fallbackFocus('password');
			if (silentID('newpwd1') == null)
				break;

			form.onsubmit = checkPwdSubmit

		case 'setPassword':
		case 'changePassword':
			setLiveCheck('newpwd2', liveCheckPwd);
			var pw1 = setLiveCheck('newpwd1', liveCheckPwd);
			if (focusFound == false && pw1) pw1.focus();
			break;

		case 'changeQAM':
			// Zijn er überhaubt invulvelden?
			if (typeof(form.extraMail) != undefined){
				var mailfield = ID('mail1')
				if (mailfield) {
					if (focusFound == false) mailfield.focus();
					setLiveCheck('mail1', compareMailFields);
					mailfield.onpaste = function () {return false};
				}
				mailfield = ID('mail2')
				if (mailfield) {
					setLiveCheck('mail2', compareMailFields);
					mailfield.onpaste = function() {return false};
				}

				setLiveCheck('question1', liveCheckQuestions);
			}
			break;

		case 'answerQuestions':
			var toggler = silentID('switchDisplayText');
			if (toggler)
				toggler.onclick = toggleClearText;

			var answerfield = ID('pleaseAnswer');
			if (answerfield) answerfield.focus();
			form.onsubmit = mixAnswers;

		break;
	}
}

function emptyQA (id) {
	var el = ID(id);
	if (el) {
		if (el.value == null) {
			var name = id.toLowerCase();
			return userError(cf['missing' + name]);
		}
	}
}

function checkQAM() {
	var Q1 = ID('question1');
	var Q2 = ID('question2');
	var A1 = ID('answer1');
	var A2 = ID('answer2');
	var Mail = ID('mail1');

	if (Q1 == null || Q2 == null || A1 == null || A2 == null || Mail == null)
		return true;

	/*
	if ((Mail.defaultValue == Mail.value) &&
	 	(Q1.defaultValue == Q1.value) &&
	 	(A1.defaultValue == A1.value) &&
	 	(Q2.defaultValue == Q2.value) &&
	 	(A2.defaultValue == A2.value)){
		return userError(cf['nothingchanged']);
	}
	*/

	if (compareMailFields() == false)
		return false;

	var changed = ID ('changed');
	if (changed == null)
		return true;

	changed.value = "1";
	return thanksForAllTheFish();
}


function liveCheckQuestions(par) {
	var x = (this.value.match(/\S\s+\S/));
	if (x == null) {
		return userError(cf['twowordsrequired']);
	} else {
		//return success('&nbsp');
		return true;
	}
}


function compareMailFields() {
	var form = ID('baseform');

	var m1 = form.extraMail.value;
	var m2 = form.mailRepeat.value;
	if (m1 != m2)
		return userError(cf['needmailtwice']);

	eraseFeedback(cf['needmailtwice'], cf['mailtwiceok']);
	return true;
}


function liveCheckPwd (){
	var form = ID('baseform');
	var result = validatePwd(form);
	if (result)
		userError(result);

	if(result == null) {
		return success(cf['nothingwrong']);
	}
}


function checkPwdSubmit(form) {
	var result = validatePwd(form);
	if (result == null) {
		return thanksForAllTheFish();
	}
	return userAlert(result);
}


function outOfRange(pwd){
	for (var i = 0; i < pwd.length; i++){
		var c = pwd.charAt(i);
		if (c.match(/[a-z]|[A-Z]|[0-9]/)) continue;
		if (cf['acceptedPasswordCharacters'].indexOf(c) >= 0) continue;
		return 1;
	}
	return 0;
}

function validatePwd(form) {
	var minLength = cf['minpasswordlength'];
    var maxLength = cf['maxpasswordlength'];

	var pw1id = ID('newpwd1');
	if (pw1id == null)
		return;

	var pw2id = ID('newpwd2');
	if (pw2id == null)
		return;

	var pw1 = pw1id.value;
	var pw2 = pw2id.value;

	if (pw1 == '')
	    return cf['neednewpwd'];

	if (outOfRange(pw1))
	    return cf['needacceptedchars'];

	if (pw1.length < minLength || pw1.length > maxLength)
	    return cf['needcorrectsize'];

	if (pw1.match(/[A-Z]/) == null || pw1.match(/[a-z]/) == null)
		return cf['needvariation'];
 
	if (pw1.match(/\d/) == null) { 
		var chars = cf['acceptedPasswordCharacters'];
		var found = 0;
		for (var i = 0; i < pw1.length; i++) {
			var c = pw1.charAt(i);
			if (cf['acceptedPasswordCharacters'].indexOf(c) >= 0) {
				found = 1;
				break;
			} 
		}
		if (found == 0) {
			return cf['needvariation'];
		}
	}

	if (pw1 != pw2)
	    return cf['needexactrepeat'];

	return null ;
}

