use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL::Request;

use UvT::Kiki::ACL::Document;

use UvT::Kiki::UI::Request -self;

sub nonce {
	return $self->is_robot || super;
}

sub login {
	return $self->remote_user || super;
}

sub authorized {
	if(my $uid = $self->remote_user) {
		my $robots = $self->cfg->allowed_robots;
		return exists $robots->{$uid};
	}
	my $uid = $self->SUPER::login;
	my $users = $self->cfg->allowed_users;
	return $uid && exists $users->{$uid};
}

sub is_robot {
	my $uid = $self->remote_user;
	return defined $uid && exists $self->cfg->allowed_robots->{$uid};
}
