# $Id: Request.pm 42205 2014-09-10 15:00:35Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Delete/Request.pm $

package UvT::Kiki::WS::Person::Delete::Request;

use UvT::Kiki::WS::Person::Request -self;

field note => sub { shift->new_person; return };

field new_person => sub {
	my $self = shift;

	my $person = super;

	if($self->nonce) {
		if($self->is_robot) {
			if($person) {
				my $name = $person->full;
				my $what = $self->is_robot ? "Robot" : "User";
				my $who = $self->login;
				my $old = $person->toString;
				my $text = "$what $who deleted person:\n\told: $old\n";

				my $note = $person->remove;
				$self->note($note);

				if($note->[0] eq 'ok') {
					warn $text;
					$self->mailtje("[kiki] $who deleted $name", $text);
					$self->activate;
				}
			} else {
				$self->note([ok => 'non-existent']);
			}
		} else {
			$self->note([error => 'no-robot']);
		}
	} else {
		$self->note([error => 'session']);
	}

	return $person;
}
