# $Id: Request.pm 46806 2017-07-26 15:48:10Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Alias/Delete/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Alias::Delete::Request;

use UvT::Kiki::WS::Alias::Request -self;

field note => sub { shift->new_alias; return };

field new_alias => sub {
	my $self = shift;

	my $alias = super;

	if($self->nonce) {
		my $name = $alias->full;
		my $what = $self->is_robot ? "Robot" : "User";
		my $who = $self->login;
		my $old = $alias->toString;
		my $text = "$what $who deleted alias:\n\told: $old\n";

		my $note = $alias->remove;
		$self->note($note);

		if($note->[0] eq 'ok') {
			warn $text;
			$self->mailtje("[kiki] $who deleted $name", $alias->diff);
			$self->activate;
		}
	} else {
		$self->note([error => 'session']);
	}

	return $alias;
}
