#! /usr/bin/env perl

# $Id: Build.PL 47130 2017-10-31 09:57:09Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/Build.PL $

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST';
	find({wanted => sub { print $fh "$_\n" or die "write(MANIFEST): $!\n" if -f }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	module_name => 'UvT::Kiki',
	dist_name => 'kiki',
	dist_version => '2.6',
	dist_abstract => 'Manage mailaliases',
	dist_author => 'Wessel Dankers <wsl@uvt.nl>',
	license => 'perl',
	create_makefile_pl => 'small',
	script_files => [],
);
$build->create_build_script;
