# $Id: Request.pm 37674 2012-08-29 08:06:04Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Activator/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Activator::Request;

use POSIX qw(_exit setsid);

use Xyzzy::Request -self;

field activation_needed => undef;

sub do_activation {
	return unless $self->activation_needed;

	my $cmd = $self->cfg->activate_command;
	return unless defined $cmd;

	my $pid = fork();
	die "fork(): $!" unless defined $pid;

	if($pid) {
		waitpid($pid, 0);
		return;
	}

	setsid() or warn "setsid(): $!\n";

	$pid = fork();
	unless(defined $pid) {
		warn "fork(): $!";
		_exit(2);
	}

	_exit(0) if $pid;

	exec($cmd);
	warn "exec($cmd) failed: $!\n";
	_exit(1);
}

sub activate {
	$self->activation_needed(1);
}
