use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL;

use UvT::Kiki::ACL::Request;
use UvT::Kiki::ACL::Document;

use Xyzzy::Handler -self;

field allowed_users => sub { shift->cfg->allowed_users };

sub handle {
	my $req = new UvT::Kiki::ACL::Request(ctx => shift, cfg => $self);
	return super($req, @_) if $req->authorized;
	my $doc = new UvT::Kiki::ACL::Document(req => $req);
	die $doc->response;
}
