package Straitjacket;
use strict;

our @EXPORT='baseconfigure';
our @ISA=('Baseobject' );

use Baseobject;
use LWP::UserAgent;
use CGI qw(:all);
use XML::LibXML;
use Carp;
use UvT_Jacket;

our $VERSION = "1.5";
our $version ='$Id: Straitjacket.pm 10514 2006-06-22 07:32:16Z anton $ ';
# $URL: https://infix.uvt.nl/its-id/trunk/sources/perlmodules/Straitjacket/lib/Straitjacket.pm $


sub new
{
  my $pkg=shift;
  my $self= bless (new Baseobject(@_),$pkg);
  if (exists ($ENV{REQUEST_URI}))
  {
    $self->{tildeusername}= ($ENV{REQUEST_URI} =~ /\~([^\/]*)/);
  }
  $self->{tildeusername}='' unless (defined($self->{tildeusername}));

  my $basename=$0;
  $basename=~s/(^.*\/)//; $basename =~ s/\..*//;

  $self->allows({'jacket'=>'https://cgi.uvt.nl/$self-{}/uvt.xml'});
  $self->allows(['content', 'hempie'  ]);

  $self->allows({ 'marker'=>'<\!--\s*application-content\s*-->',
		  'rel2absurls'=>"http://www.uvt.nl",
		  'substurl'=>'http:\/\/images\.uvt\.nl',
		  'imagebase'=>'https://kubsu3.uvt.nl/images/uvt',
		  'cssbase'=>'http://images.uvt.nl/images/uvt/_styles',
		  'title'=>$basename,
		  'clickpathappname'=>'',
		  'printbutton'=>0,

		     });


  $self->fields(@_);
  unless ($self->field('hempie'))
  {
    $self->field ('hempie',
		  "<html><b><font color=\"red\"> UvT Web could not be reached, ignoring housestyle!</font></b>
                   <br\><br\> $self->{fields}->{marker} </html>");
  }

  my $cgi=new CGI();
  $self->{cgi}=$cgi;


  #nojacket? we dont want the jacket
  $self->{nojacket} = $self->{cgi}->param('nojacket');

  my $UvTjacket=new UvT_Jacket();
  $self->{smug}=$UvTjacket->{content};
#  $self->{smug}=$self->getresource($self->field('jacket'))  unless ($self->error() or $self->{nojacket});
  return $self;
}

sub present
{
  my $self=shift;
  print "Content-type:text/html\n\n".$self->strapjacket(@_);
}



sub strapjacket
{
  my $self=shift;

  unless (ref ($_[0]))
  {
    $self->field('content',$_[0]) if (defined $_[0]);
  }
  else
  {
    $self->fields(@_);
  }

  my $marker=$self->field('marker');
  my $smug=$self->{smug};

  return $self->field('content') if ($self->{nojacket});

  #jacket not found? don't try to slip into it
  unless ($smug)
  {
    $self->error("Warning jacket not found\n");
     return undef ;
  }

  #parse the xml tree
  my $parser=XML::LibXML->new('1.0', 'UTF-8');
  my $doc=$parser->parse_string($smug);

  $self->adjustdocument($doc);
  my $string=  $doc->toStringHTML();

  if ($self->{fields}->{content})
  {
    $string =~ s/$self->{fields}->{marker}/$self->{fields}->{content}/gs;
  }
  $string;
}

sub presubstAttribs
{
  my ($self,$doc,$attriblist,$content,$subst)=@_;
  my  $docroot= $doc->documentElement();

  foreach my $attrib (@$attriblist)
  {
    my $xpath="//*[\@$attrib]",
    my @nodes;
    @nodes=$docroot->findnodes($xpath);
    unless ( @nodes)
    {
      $self->stderror( "presubstAttribs: No nodes found for: $xpath!");
      return;
    }
    foreach my $node  (@nodes)
    {
      my $currentcontent=$node->getAttribute($attrib);
      if ($currentcontent=~s/$subst//)
      {
	$node->removeAttribute($currentcontent);
	$node->setAttribute($attrib,"$content/$currentcontent");
      }
    }
  }
}


sub substNodes
{
  my ($self,$doc,$xpath,$content,$subst)=@_;
  my $docroot= $doc->documentElement();

  my @nodes;

  @nodes=$docroot->findnodes($xpath);
  unless ( @nodes)
  {
    $self->stderror( "substNodes: No nodes found for: $xpath!");
    return;
  }
  foreach my $node  (@nodes)
  {
    my @childnodes=$node->childNodes;

    warn "substnodes";

    foreach my $childnode (@childnodes)
    {
      my $orgval= $node->textContent();
      my $newnode;
      warn "-------------- ,$orgval $subst, $content";
      if ($orgval=~ s/$subst/$content/sg)
      {
	warn "substituting";
	$newnode=$doc->createTextNode($orgval);
 	# hierna hangt $doc->toString(), dus laat maar
#	 $node->replaceChild($childnode,$newnode);
	$node->removeChild($childnode);
	$node->appendChild($newnode);
      }
    }
  }
}

#  $self->substcontent($doc,'appl_name',$self->{fields}->{title})

sub substcontent
{
  my ($self,$doc,$id,$content)=@_;
  my $docroot= $doc->documentElement();

   my @nodes;

  my $xpath="//*[\@id=\'$id\']";

  @nodes=$docroot->findnodes($xpath);
  unless ( @nodes)
  {
    $self->stderror( "substcontent: No nodes found for: $xpath!");
    return;
  }

  foreach my $node  (@nodes)
  {
    my $newnode=$doc->createTextNode($content);
    $node->appendChild($newnode);
  }
}




sub adjustdocument
{
  my ($self,$doc)=@_;

  # locate images, <img src="" >
#  $self->presubstAttribs($doc,[qw (src href)],$self->{fields}->{imagebase},$self->{fields}->{substurl});
#  $self->substNodes($doc,"//style[\@type='text/css']",$self->{fields}->{imagebase},$self->{fields}->{substurl});

#  werkt nog niet
#  $self->substNodes($doc,"//script[\@type='text/javascript']",$self->{fields}->{imagebase},$self->{fields}->{substurl});

  $self->substcontent($doc,'title',$self->{fields}->{title});
  $self->substcontent($doc,'clickpath_appname',$self->{fields}->{clickpathappname});

#  $self->substcontent($doc,'appl_content',$self->{fields}->{content});
#  warn $doc->toString(2);
}


sub warning
{
  my $warning=shift;

  warn "http_referer: $ENV{'HTTP_REFERER'}\n" if (exists ($ENV{'HTTP_REFERER'}));
  warn "remote_addr:$ENV{'REMOTE_ADDR'}\n" if (exists ($ENV{'REMOTE_ADDR'}));
  warn $warning;

}


sub getresource
{
  my $self=shift;
  my $resource=shift;

  if ($resource =~ /^https?:\/\//i)
  {
    my $res=$self->geturl($resource);
    unless ($res->is_success)
    {
      $self->mail ( "UvT-web out of reach! \"$resource\" ".$res->status_line."\n" );
      return $self->field('hempie');
    }
    else
    {
      my $content=$res->content();
      # verplaats deze check
#      unless ($content =~ /$self->{fields}->{marker}/s)
#      {
#	$self->mail ( "resource on UvT-web returned no valid marker: \"$resource\"\n" );
#	$content=$self->field('hempie');
#      }
      return $content;
    }
  }
  else
  {
    return $self->getfile($resource);
  }
}

sub getfile
{
  my $self=shift;
  my $file=shift;

  open (FH,$file) or $self->stderror("Could not open file: $file: $! ") && return undef;
  my $content;
  while (<FH>)
  {
    $content.=$_;
  }
  close FH;
  $content;
}


my $ua;
sub geturl
{
  my $self=shift;
  unless (defined($ua))
  {
    $ua = LWP::UserAgent->new;
    $ua->agent("$0/0.1 " . $ua->agent);
  }

  my $url=shift;
  my $req = HTTP::Request->new(GET => $url);
  $req->header('Accept' => 'text/html');

# send request
  my $res = $ua->request($req);
  return $res;
}


sub mail
{
  my $self=shift;
  if (defined ($Errorlog::SELF))
  {
    $Errorlog::SELF->mail(@_);
  }
  elsif (defined ($main::log))
  {
     $main::log->mail(@_);
  }
  else
  {
    carp ("NOT mailing:",@_);
  }
}


42;


__END__

=head1 Straitjacket.pm

=head1 SYSNOPSIS

Put on the only straight uniform we all believe in (at the moment).

=head1 DESCRIPTION

Half DOM version 1.4.
Inbetween release, waiting for new developments in UvT WEB.

Provides a uniform housestyle makeup for a web page, and insert
content at a dedecated location within this makeup.


=head1 DETAILS

Optionally replaces relative urls by an absolute one (ugh).

In addition: Any URL of the form: /http:\/\/.*?\.html\.print/i is
substituted by a references to this exact script with an additional
variable: nojacket=1, which if called generates an jacketless
'content'.  For the moment this ONLY WORKS for the GET method. A later
version might possibly support POST, maybe (not likely though).


=head1 DEPENDENCIES:
    Baseobject.pm LPW::UserAgent CGI


=head2 EXAMPLE

 use Straitjacket;

 my $glammor;
 my $language='english';
 my $content = getcontentfromsomewhere();

 my $server={'english'=>'www.tilburguniversity.nl',
     'dutch'=>'www.uvt.nl'};

 #refer to a file or an url
 my $suit="http://$server->{$language}/diensten/drc/htdig/$language/result.html";

 #create the jacket
 my $jacket=new Straitjacket({'content'=>$content,
                     'jacket'=>$suit,
                     'rel2absurls'=>"http://www.uvt.nl";
                       });

 $glammor=$jacket->strapjacket() ;
 die $jacket->error()  if ($jacket->error()) ;
 print $jacket->present();


=head1 METHODS

=head1 new()

=head2 SYNOPSIS:

Create an object, to be activated by calling strapjacket()

=head2 PARAMETERS:

    allows:
        jacket
            The URL or filename of the jacket (smug, facade, dress, whatever). default: http://www.uvt.nl/diensten/drc/appl_content.html

        content
            The content to be wrapped up in the jacket

        marker
            A unique string in the jacket to be replaced by the content. The default value of this marker is: <!-- application-content -->

        rel2absurls
            Default: http://www.uvt.nl Convert all relative (href|src|action) urls into this absolute url.

            Set to false if you dont want this!

        printbutton
            Default: 0 Removes the printbutton local to Tilburg University. Set to true in order to have it spared from removal.

        clickpathappname
            If supplied this string replaces the string <!-- appl_name--> to be shown in the 'klikpad'
            Hope this stupid idea will be history soon.

    sneeks in:

        nojacket
            If the CGI variable 'nojacket' is set to non-zero NO JACKET is put on.




=head1 present()

=head2 SYNOPSIS:

call strapjacket() pre attach leading ``Content-type:text/html\n\n'' and print it to stdout.

=head2 PARAMETERS:

The same parameters as with new() may be presented again, OR a single string may be passed, which is interpreted as the 'content' field.

=head2 RETURNS:

String: Content-type followd by the jacket wrapped firmly around the content.

If no content is provided, the jacket is returned still containing the original

If no jacket is provided, the content is returned.


=head1 strapjacket()

=head2 SYNOPSIS:

Combine all provided parameters and return a synthesized string.

=head2 PARAMETERS:

The same parameters as with new() may be presented again, OR a single string may be passed, which is interpreted as the 'content' field.

=head2 RETURNS:

String, containging the jacket wrapped firmly around the content.

If no content is provided, the jacket is returned still containing the original marker.

If no jacket is provided, the content is returned.

=head1 AUTHOR

Anton Sluijtman, E<lt>anton@uvt.nlE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by anton sluijtman

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.4 or,
at your option, any later version of Perl 5 you may have available.



=cut

