#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('UvT::VLAN') or BAIL_OUT('need UvT::VLAN to run') }

my $v = new_ok('UvT::VLAN', [configfile => 't/tests.cfg']) or BAIL_OUT('need a UvT::VLAN object to run');

is(do { local $@; eval { $v->ip2vlan('137.56.246.123') } // $@ }, 'xe', "able to look up an IP address");
is(do { local $@; eval { $v->host2vlan('localhost') } // $@ }, 'lo', "able to look up a domain name");
is(do { local $@; eval { $v->ip2vlan('137.56.200.123') // 'UNDEF' } // $@ }, 'UNDEF', "unknown IP address returns undef");
is(do { local $@; eval { $v->host2vlan('asdkjfhsdklfjh') } // $@ }, "no IP-adddress found for host 'asdkjfhsdklfjh'\n", "unknown domain name dies");

done_testing();
