<xsl:transform
	version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:html="http://www.w3.org/1999/xhtml"
	exclude-result-prefixes="html">

	<!-- $Id: html.xsl 39265 2013-04-19 08:15:20Z wsl $ -->
	<!-- $URL: https://svn.uvt.nl/its-id/trunk/personal/wsl/mailtemplate/html.xsl $ -->

	<xsl:output method="html" media-type="text/html" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

	<xsl:template match="/">
		<xsl:apply-templates select="persoon"/>
	</xsl:template>

	<xsl:template match="persoon">
		<html style="background: #ddd">
			<body style="background: #ddd" link="#008ec6" vlink="#008ec6" alink="#000">
				<div align="center">
					<table style="background: #fff; width: 435pt; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; -moz-box-shadow: 3px 3px 12px #aaa; -webkit-box-shadow: 3px 3px 12px #aaa; -khtml-box-shadow: 3px 3px 12px #aaa; -o-box-shadow: 3px 3px 12px #aaa; box-shadow: 3px 3px 12px #aaa">
						<thead>
							<tr>
								<td align="left" style="padding: 14pt 14pt 7pt 14pt; width: 50%">
									<img src="data:data:image/png;base64,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" alt="TiU logo"/>
								</td>
								<td align="right" style="padding: 14pt 20pt 7pt 14pt; width: 50%">
									<img src="data:data:image/png;base64,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" alt="TiU slogan"/>
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<hr noshade="noshade" size="1" style="color: #c93; background-color: #c93; height: 1px; border: none"/>
								</td>
							</tr>
						</thead>
						<tbody>
							<tr>
								<th scope="col" lang="nl" align="left" style="padding: 14pt 14pt 14pt 14pt">
									<h1 style="text-align: bottom; font-family: Arial, sans-serif; font-size: 21pt; font-weight: normal; color: #cc9933">accountinformatie</h1>
								</th>
								<th scope="col" lang="en" align="left" style="padding: 14pt 14pt 14pt 14pt">
									<h1 style="text-align: bottom; font-family: Arial, sans-serif; font-size: 21pt; font-weight: normal; color: #cc9933">account information</h1>
								</th>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Beste student,</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Dear student,</td>
							</tr>

							<xsl:choose>
								<xsl:when test="type='herinschrijver'">
									<tr>
										<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Je ontvangt deze mail omdat je weer recht hebt op gebruik van de online faciliteiten van Tilburg University. Hieronder tref je jouw accountgegevens aan.</td>
										<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">You recieve this mail because you are entitled again to use the online facilities of Tilburg University. Please find below the information for your account.</td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">In deze mail tref je de gegevens aan van je Tilburg University account, waarmee je gebruik kan maken van onze online faciliteiten.</td>
										<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Please find below the information for your Tilburg University account. You will need this account to gain access to our online facilities.</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>

							<tr align="center">
								<td colspan="2" lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
									<table border="1" bordercolor="#c3bcb2" align="center" cellspacing="0" cellpadding="0" style="border: 1px solid #c3bcb2; border-collapse: collapse">
										<tr align="left" valign="top">
											<th align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0">User name:</th>
											<td align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0"><xsl:value-of select="uid"/></td>
										</tr>
										<tr align="left" valign="top">
											<th align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0">Mail address:</th>
											<td align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0"><xsl:value-of select="mail"/></td>
										</tr>
										<tr align="left" valign="top">
											<th align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0">Student number:</th>
											<td align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0"><xsl:value-of select="emplid"/></td>
										</tr>
										<tr align="left" valign="top">
											<th align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0">ANR (University card):</th>
											<td align="left" valign="top" style="text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0"><xsl:value-of select="anr"/></td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
									<em>Door middel van het instellen van je password activeer je jouw account. Raadpleeg voordat je dit doet eerst de <a style="color: #008ec6" href="http://www.tilburguniversity.edu/upload/a4481b4c-b2f8-4a6f-bd3f-4607882aa239_gedragscodeict.pdf">voorwaarden voor gebruik</a> in de 'Gedragscode e-mail-, internet- en telefoonfaciliteiten'. Met het activeren van je account stem je in met de gedragscode.</em>
								</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
									<em>By setting the password you will activate your account. Before you put this into effect, please consult the <a style="color: #008ec6" href="http://www.tilburguniversity.edu/upload/bf821b8a-326b-4fb7-ab14-1c8b50382d6b_email-telephone.pdf">conditions for use</a> in the 'Code of Conduct for the Use of E-mail, Internet and Telephone Facilities'. By activating your account you consent to this Code of Conduct.</em>
								</td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Klik op onderstaande link om je eigen password aan te maken. Je ontvangt dan binnen 10 minuten een mail van de LIS Service Desk. Deze mail bevat een beveiligde link waarmee je je password kan instellen.</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">After clicking the link below you will receive an email within 10 minutes from the LIS Service Desk which contains a secured link that enables you to set your own password.</td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Ga naar de <a style="color: #008ec6" href="https://cgi.uvt.nl/cgi-bin/gatekeeper/mailchallenge?language=nl&amp;uid={uid}">Selfservice universiteitsaccount</a>.</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Go to the <a style="color: #008ec6" href="https://cgi.uvt.nl/cgi-bin/gatekeeper/mailchallenge?uid={uid}">Self-service university account</a>.</td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Als je geen mail krijgt:<ul style="margin-before: 0pt; -moz-margin-before: 0pt; -webkit-margin-before: 0pt; -khtml-margin-before: 0pt; -o-margin-before: 0pt; margin-after: 0pt; -moz-margin-after: 0pt; -webkit-margin-after: 0pt; -khtml-margin-after: 0pt; -o-margin-after: 0pt"><li style="margin-left: 0pt">Controleer je junk- of spammailfolder.</li><li style="margin-left: 0pt">Voeg lis-servicedesk@uvt.nl toe aan je lijst met mailcontacten of whitelist.</li><li style="margin-left: 0pt">Gebruik de link opnieuw.</li><li style="margin-left: 0pt">Vraag ondersteuning bij de <a style="color: #008ec6" href="http://www.tilburguniversity.edu/nl/studenten/it/lis-sd/">Service Desk</a> van Library &amp; IT Services.</li></ul></td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">If you do not receive this mail:<ul style="margin-before: 0pt; -moz-margin-before: 0pt; -webkit-margin-before: 0pt; -khtml-margin-before: 0pt; -o-margin-before: 0pt; margin-after: 0pt; -moz-margin-after: 0pt; -webkit-margin-after: 0pt; -khtml-margin-after: 0pt; -o-margin-after: 0pt"><li style="margin-left: 0pt">Check your junk or spam mail folder.</li><li style="margin-left: 0pt">Add lis-servicedesk@uvt.nl to your mail contacts list or whitelist.</li><li style="margin-left: 0pt">Try the link again.</li><li style="margin-left: 0pt">Ask the <a style="color: #008ec6" href="http://www.tilburguniversity.edu/students/it/lis-sd/">Service Desk</a> of Library &amp; IT Services for support.</li></ul></td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Je Tilburg University mailbox kan je raadplegen via <a style="color: #008ec6" href="www.tilburguniversity.edu/cloud/mail">www.tilburguniversity.edu/cloud/mail</a>.</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">To access your Tilburg University mailbox, please visit <a style="color: #008ec6" href="www.tilburguniversity.edu/cloud/mail">www.tilburguniversity.edu/cloud/mail</a>.</td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Houd er rekening mee dat je username en password strikt persoonlijk zijn en onder geen beding aan anderen ter beschikking gesteld mogen worden.</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Keep in mind that your user name and password are strictly personal and under no circumstances should be given to others.</td>
							</tr>
							<xsl:if test="type!='exchange'">
								<tr>
									<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Let op: je account wordt automatisch geblokkeerd als je inschrijving niet tijdig wordt afgerond. Informatie over het verloop van de inschrijfprocedure is te vinden op de <a style="color: #008ec6" href="https://tiu.nu/Inschrijving">Inschrijvingswebsite</a>.</td>
									<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Please notice that your account will be blocked if your registration is not completed in time. More information about the registration procedure can be found on the <a style="color: #008ec6" href="https://tiu.nu/registration">Registration website</a>.</td>
								</tr>
							</xsl:if>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Met vriendelijke groet,</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Yours sincerely,</td>
							</tr>
							<tr>
								<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Student Administration<br/>Tilburg University</td>
								<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">Student Administration<br/>Tilburg University</td>
							</tr>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="2">&#160;</td>
							</tr>
							<tr>
								<td colspan="2" style="padding: 0pt 0pt 0pt 0pt">
									<hr noshade="noshade" size="1" style="color: #c93; background-color: #c93; height: 1px; border: none"/>
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<p style="font-family: Arial, sans-serif; font-size: 80%; color: #c3bcb2; text-align: center; margin: 0pt 0pt 0pt 0pt">Tilburg University &#8211; Warandelaan 2 &#8211; 5037 AB Tilburg</p>
									<p style="font-family: Arial, sans-serif; font-size: 80%; color: #c3bcb2; text-align: center; margin: 0pt 0pt 10pt 0pt"><a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/" target="_blank">www.tilburguniversity.edu</a> &#8211; <a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/nl/contact/" target="_blank">routebeschrijving</a> | <a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/contact/" target="_blank">route description</a></p>
								</td>
							</tr>
						</tfoot>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:transform>
