use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::CAS::Document;

use Xyzzy::Document -self;

sub session_cookie {
	my $session = $self->req->new_session;
	my $cookie = $self->bakecookie(session => $session);
	$cookie->setparameter(HttpOnly => 1);
	return $cookie;
}

sub response {
	my $url = $self->req->cas_clean_url;
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setcookie($self->session_cookie);
	$res->addheader(Location => $url);
	$res->addheader('Cache-Control' => 'private');
	return $res;
}
