use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::CAS;

use LWP;

use Xyzzy::Crypto;
use Xyzzy::CAS::Request;
use Xyzzy::CAS::Document;

use Xyzzy::Handler -self;

my $have_curl;
BEGIN { $have_curl = eval "use WWW::Curl::Easy; 1" }

field crypto => sub { new Xyzzy::Crypto(cfg => shift->cfg) };
field cas_login_url => sub { shift->cfg->cas_login_url };
field cas_validate_url => sub { shift->cfg->cas_validate_url };
field cas_domain => sub { shift->cfg->cas_domain };
field cas_force_https => sub { shift->cfg->cas_force_https };
field cas_force_domain => sub { shift->cfg->cas_force_domain };
field cas_snoop => undef;
field cas_lwp => sub { new LWP::UserAgent(keep_alive => 2) };
field cas_use_curl => sub { $have_curl && shift->cfg->cas_use_curl };
	
field cas_curl => sub {
	my $curl = WWW::Curl::Easy->new;
	$curl->setopt(CURLOPT_TIMEOUT(), 5);
	$curl->setopt(CURLOPT_NOSIGNAL(), 1);
	return $curl;
};

sub handle {
	my $req = new Xyzzy::CAS::Request(ctx => shift, cfg => $self);

	if($req->valid_ticket) {
		my $doc = new Xyzzy::CAS::Document(req => $req);
		if($self->cas_snoop) {
			my $res = eval { super($req, @_) };
			my $err = $@;
			if($err) {
				die $err unless UNIVERSAL::isa($err, 'Xyzzy::Response');
				$res = $err;
			}
			confess("internal error") unless $res;

			if($res->headers->{Location}) {
				$res->setcookie($doc->session_cookie);
				$res->addheader('Cache-Control' => 'private');
				die $res if $err;
				return $res;
			}
		}
		die $doc->response;
	}

	my $res = eval { super($req, @_) };
	my $err = $@;
	if($err) {
		die $err unless UNIVERSAL::isa($err, 'Xyzzy::Response');
		$res = $err;
	}
	confess("internal error") unless $res;
	if($req->cur_session ne $req->new_session) {
		my $doc = new Xyzzy::CAS::Document(req => $req);
		$res->setcookie($doc->session_cookie);
	}
	$res->addheader('Cache-Control' => 'private');
	die $res if $err;
	return $res;
}
