#! /usr/bin/env perl

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST' or die "open(MANIFEST): $!\n";
	find({wanted => sub { return unless -f; print $fh "$_\n" or die "write(MANIFEST): $!\n" }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	dist_name => 'xyzzy',
	dist_version => '7.13',
	dist_author => 'Wessel Dankers <wsl@fruit.je>',
	dist_abstract => 'DOMXML based website framework',
	module_name => 'Xyzzy',
	license => 'perl',
	create_makefile_pl => 'small',
	script_files => [],
);

$build->create_build_script;
