package Xyzzy::LDAP::Config;

use Clarity -self;

use Net::LDAP::Filter;
use Xyzzy::Util qw(parse_time parse_bool);

field ldap_server => 'ldap://localhost';
field ldap_base => sub { die "no LDAPBase configured\n" };
field ldap_filter => undef;
field ldap_attribute => 'uid';
field ldap_username => sub { die "LDAPPassword configured but not LDAPUsername\n" if defined shift->ldap_password };
field ldap_password => undef;
field ldap_timeout => 10;
field ldap_secure => 1;
field ldap_capath => undef;
field ldap_cafile => undef;
field ldap_clientcert => undef;
field ldap_clientkey => sub { die "LDAPClientCertificate configured but not LDAPClientKey\n" if defined shift->ldap_clientcert };
field ldap_ciphers => 'ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES128-GCM-SHA256';
field ldap_sslversion => 'tlsv1_2';

sub set_ldapserver; *set_ldapserver = \&ldap_server;
sub set_ldapbase; *set_ldapbase = \&ldap_base;
sub set_ldapattribute; *set_ldapattribute = \&ldap_attribute;
sub set_ldapusername; *set_ldapusername = \&ldap_username;
sub set_ldappassword; *set_ldappassword = \&ldap_password;
sub set_ldapciphers; *set_ldapciphers = \&ldap_ciphers;
sub set_ldapsslversion; *set_ldapsslversion = \&ldap_sslversion;

sub set_ldapfilter {
	my $filter = shift;
	my $compiled = eval { new Net::LDAP::Filter($filter) };
	die "error parsing LDAP filter '$filter': $@" if $@;
	die "error parsing LDAP filter '$filter'\n" unless defined $compiled;
	$self->ldap_filter($compiled);
}

sub set_ldaptimeout {
	$self->ldap_timeout(parse_time(shift));
}

sub set_ldapsecure {
	$self->ldap_secure(parse_bool(shift));
}

sub set_ldapcafile {
	my $value = shift;
	die "LDAPCAfile '$value' not accessible\n" unless -r $value;
	die "LDAPCAfile '$value' not a file\n" unless -f _;
	$self->ldap_cafile($value);
}

sub set_ldapcapath {
	my $value = shift;
	die "LDAPCApath '$value' not accessible\n" unless -r $value;
	die "LDAPCApath '$value' not a directory\n" unless -d _;
	$self->ldap_capath($value);
}

sub set_ldapclientcertificate {
	my $value = shift;
	die "LDAPClientCertificate '$value' not accessible\n" unless -r $value;
	die "LDAPClientCertificate '$value' not a file\n" unless -f _;
	$self->ldap_clientcert($value);
}

sub set_ldapclientkey {
	my $value = shift;
	die "LDAPClientKey '$value' not accessible\n" unless -r $value;
	die "LDAPClientKey '$value' not a file\n" unless -f _;
	$self->ldap_clientkey($value);
}
