use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Method;

use Xyzzy::Fail;
use Xyzzy::Method::Request;

use Xyzzy::Handler -self;

field methods => {};

sub handle {
	my $req = new Xyzzy::Method::Request(cfg => $self, ctx => shift);

	my $method = $req->method;
	my $methods = $self->methods;
	my $handler = $methods->{$method};
	$handler //= $methods->{GET}
		if $methods eq 'HEAD';
	return $self->handler->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
