use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Static;

use Xyzzy::Static::Request;
use Xyzzy::Static::Document;

use Xyzzy::Handler -self;

field file => undef;
field contentdir => sub { shift->cfg->contentdir };
field static_stylesheet => sub { shift->cfg->static_stylesheet };
#field denied => sub { new Xyzzy::Fail(cfg => shift, code => 403) };
#field fallback => sub { new Xyzzy::Fail(cfg => shift, code => 404) };

sub handle {
	my $req = new Xyzzy::Static::Request(ctx => shift, cfg => $self);
	my $doc = new Xyzzy::Static::Document(req => $req);

	return $doc->response;
}
