#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Test::More;
use Encode qw(is_utf8);

BEGIN { use_ok('Xyzzy::Response') or BAIL_OUT('need Xyzzy::Response to run') }

my $res = new_ok('Xyzzy::Response', [content => 'あ']) or BAIL_OUT('need a Xyzzy::Response object to run');

my $cgi = $res->as_cgi;

ok(!is_utf8(join('', @$cgi)), "Output is not UTF-8 even if content is");

done_testing();
