# $Id: Error.pm 35760 2011-10-12 18:43:33Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Error.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Error;

use Clarity -self;

my %messages = (
	0x0000 => ['Success', "Indicates successful processing. This error is never returned but is used by A-Select for internal processing."],
	0x0001 => ['Internal error in A-Select', "The A-Select Server could not handle the request due to an internal error."],
	0x0002 => ['User unknown', "User does not exist in the user database."],
	0x0003 => ['Could not authenticate user', "The A-Select Server could not authenticate the user. User tried to access an application which has a higher level than the user can authenticate for."],
	0x0004 => ['Credentials are not valid', "There is no valid Ticket Granting Ticket (TGT) for the user while verifying the A-Select credentials. The credentials are invalid."],
	0x0007 => ['Credentials are not valid', "There is no valid Ticket Granting Ticket (TGT) for the user while verifying or killing the A-Select TGT."],
	0x0008 => ['Account is disabled', "The user account is disabled in the A-Select user database."],
	0x0009 => ['Not allowed', "The user has insufficient rights to authenticate with an AuthSP that has a sufficient level for the application that is authenticated for."],
	0x000a => ['Authentication failed', "The AuthSP returned an error during the authenticating process of a user."],
	0x000b => ['Access denied', "A response from an AuthSP or remote A-Select server, in cross A-Select mode, could not be verified by the A-Select Server."],
	0x0030 => ['Invalid request', "An invalid request was received by the A-Select Server."],
	0x0031 => ['Application unknown', "The application the user tried to authenticate for is unknown by this A-Select Server. An unknown application id was provided. The A-Select Server does not know the application that is initiating authentication or sending API calls."],
	0x0032 => ['Application unreachable', "The application the user tried to authenticate for could not be reached by the A-Select Server. An invalid application URL was sent to the A-Select Server. The application the user is authenticating for could not be reached."],
	0x0033 => ['A-Select Server ID mismatch', "An API call is issued to the A-Select server which was not meant for this Server."],
	0x0034 => ['Unknown remote organization requested', "A remote organization was specified in the request that the A-Select Server does not know."],
	0x0035 => ['Invalid application level', "The application does not meet the defined level."],
	0x0040 => ['User cancelled', "The user has cancelled authentication."],
	0x0050 => ['A-Select server is busy', "Please try again later. The A-Select server has reached the maximum of sessions or Ticket Granting Tickets (TGT)"],
	0x0060 => ['Internal error in the A-Select User Database', "The A-Select Server could not handle the request due to an internal error in the User Database (UDB)."],
	0x0070 => ['Session is not valid', "The retrieved session ID is not valid. A request was issued with an unknown or expired session. If the A-Select Server can determine that the session has expired a 0102 error is returned."],
	0x0101 => ['Internal error', "The A-Select Agent could not handle the request due to an internal error."],
	0x0102 => ['Session has expired', "The retrieved session ID corresponds to a session that has expired. A request was issued to the A-Select server with a RID corresponding to a session that has already been cleaned."],
	0x0109 => ['Ticket is not valid', "The submitted user id and/or organization ID do not match the user and/or organization in the Agent ticket context."],
	0x010a => ['Ticket has expired', "The submitted ticket has been expired at the Agent."],
	0x010b => ['Unknown ticket', "The A-Select Agent does not know the submitted ticket."],
	0x010c => ['A-Select server unreachable', "The A-Select Agent could not reach the A-Select Server."],
	0x010d => ['Ticket number exceeded', "The maximum number of issued tickets has been reached."],
	0x010e => ['Attributes mismatch', "A verify ticket request was issued and the received attributes do not match the stored attributes."],
	0x0130 => ['Invalid request', "An invalid request was received by the A-Select Agent."],
	0x0140 => ['User is not authorized', "The user is not authorized to access the application the user is authenticated for."],
	0x0141 => ['Authorization disabled', "A-Select Authorization is not enabled in the Agent."],
	0x4002 => ["Can't open data source", "Internal error in A-Select component while opening a resource (such as a file or database connection)."],
	0x4003 => ["Can't close data source", "Internal error in A-Select component while closing a resource (such as a file or database connection)."],
	0x4004 => ['Read error while reading from data source', "Internal error in A-Select component while reading from a resource (such as a file or database connection)."],
	0x4005 => ['The requested item was not found', "A requested item (such as a configuration parameter or a file) was not found."],
	0x4006 => ['I/O error', "Internal error in A-Select component. I/O execution failed."],
	0x4007 => ['Use error', "Internal error in A-Select component. Wrong use of methods or other functionality. Possibly incompatible versions of the A-select software were used."],
	0x4008 => ['Parse error', "Internal error in A-Select component. Parsing of a document, request, URL, etc. failed."],
	0x4009 => ['Initialization failed', "System initialization failed."],
	0x4010 => ['Username unknown', "Internal error in A-Select component. User is not known to the attribute-gathering component."],
	0x4011 => ['Configuration error', "Internal error in A-Select component. An error was found in the configuration during runtime."],
	0x5001 => ['Database initialization failure', "Internal error in database communication. Initialization of a database resource failed."],
	0x5002 => ['Database connection failure', "Internal error in database communication. Communication with a database resource failed."],
	0x5003 => ['Database query failure', "Internal error in database communication. Database query failed."],
	0x5004 => ['Database update query failure', "Internal error in database communication. Database update failed."],
	0x6001 => ['Storage initialization failure', "Internal error in Storage Manager. Initialization of the storage manager failed."],
	0x6002 => ['Storage retrieval failure', "Internal error in Storage Manager. Retrieving an item from storage failed."],
	0x6003 => ['Storage key not found', "Internal error in Storage Manager. Storage key was not found."],
	0x6004 => ['Storage insertion failure', "Internal error in Storage Manager. Adding an item to storage failed."],
	0x6005 => ['Storage removal failure', "Internal error in Storage Manager. Removing an item from storage failed."],
	0x6006 => ['Storage cleanup failure', "Internal error in Storage Manager. Cleaning of a resource item failed."],
	0x6009 => ['Storage connection failure', "Internal error in Storage Manager. Connecting to a storage resource failed."],
	0x6010 => ['Maximum storage items reached', "Internal error in Storage Manager. The maximum number of storage items has been reached."],
	0x7001 => ['SAM resource not available', "Internal error in SAM. A SAM resource did not respond or if there are no resources configured."],
	0x7002 => ['No active SAM resource', "Internal error in SAM. There are currently no active resources."],
);

sub new {
	my $class = ref $self || $self;
	my $code = shift;
	$code = defined $code ? hex($code) : 1;
	return bless \$code, $class;
}

sub code { sprintf('%04x', $$self) }
sub lookup { @{$messages{$$self}} }
sub message { ($messages{$$self} // return)->[0] }
sub description { ($messages{$$self} // return)->[1] }
sub toInt { $$self }
sub ok { $$self == 0 }

use overload
	'""' => \&code,
	'0+', => \&toInt,
	'bool' => \&ok,
	fallback => 1;
