# $Id: Request.pm 36052 2011-11-17 18:43:03Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Request;

use Aselect::UI::Login::Request -self;

param username => sub {
	return unless defined;
	s/\s+//g;
	$_ = lc;
};

param password;

bool_param gateway;

field message => undef;

const uid => sub {
	my $self = shift;

	return undef unless $self->lt;

	my $username = $self->username;
	my $password = $self->password;

	return undef unless $username && $password;

	my $uid = eval { $self->dir->authenticate($username, $password) };
	die $self->error('backend', $@, username => $username) if $@;
	unless(defined $uid) {
		$self->message('credentials');
		sleep(1);
	}

	return $uid;
};

field new_session => sub {
	my $self = shift;
	my $uid = $self->uid;
	return $uid && $self->effective_remember
		? $self->create_session($uid)
		: $self->SUPER::new_session;
};
