# $Id: Request.pm 35786 2011-10-17 15:25:44Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/RequestAuthentication/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::RequestAuthentication::Request;

use Aselect::URL qw(normalize_url valid_http_url);

use Aselect::WS::Responder::Request -self;

param signature => sub { die "0030 Required request parameter 'signature' not supplied\n" unless defined };

param app_id;
param app_url => sub {
	die "0030 Required parameter 'app_url' not supplied\n" unless defined;
	$_ = normalize_url($_);
};

param local_organization;
param local_as_url => sub {
	die "0030 Required parameter 'local_as_url' not supplied\n" unless defined;
	$_ = normalize_url($_);
};

const requestor_origin => sub { shift->rid; return };
const requestor_id => sub { shift->rid; return };
const requestor_url => sub { shift->rid; return };

const rid => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	my ($origin, $id, $url);

	if(my $app_id = $self->app_id) {
		$origin = 'l';
		$id = $app_id;
		$url = $self->app_url;
	} elsif(my $local_organization = $self->local_organization) {
		$origin = 'r';
		$id = $local_organization;
		$url = $self->local_as_url;
	} else {
		die "0030 No 'app_id' or 'local_organization' parameter supplied\n";
	}

	$self->{requestor_id} = $id;
	$self->{requestor_origin} = $origin;

	die "0032 Invalid URL specified\n"
		unless valid_http_url($url);

	my $re = $self->cfg->urlfilter;
	die "0032 Invalid URL specified\n"
		unless $url =~ $re;

	unless($self->correct_signature_found) {
		my $re = $self->cfg->servicefilter;
		die "0032 Invalid URL specified\n"
			unless $url =~ $re;
	}

	$self->{requestor_url} = $url;

	return scalar $self->crypto->create_token('r', $origin, $id, $url);
};

const correct_signature_found => sub {
	my $self = shift;
	return $self->check_signature(@{$self->signature_params});
};

sub response {
	$self->correct_signature_found;

	my $as_url = $self->cfg->login_url // $self->script_url . '/login';

	return {result_code => '0000', rid => $self->rid, as_url => $as_url};
}

sub signature_params {
	my $origin = $self->requestor_origin or confess 'internal error';
	return $origin eq 'l' ? [qw(a-select-server app_id app_url country forced_logon language remote_organization uid)]
		: $origin eq 'r' ? [qw(a-select-server arp_target country forced_logon language
			local_as_url local_organization remote_organization required_level uid)]
		: confess 'internal error';
}
