# $Id: Error.pm 36089 2011-11-23 19:23:06Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/Error.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Error;

use Aselect::UI::Document -self;

field type;
field args;

sub build {
	my $root = $self->construct('error', [code => $self->type]);
	$self->setDocumentElement($root);
	my $args = $self->args;
	if(%$args) {
		my $arglist = $self->construct('args');
		while(my ($key, $val) = each(%$args)) {
			$arglist->appendChild($self->construct($key, "$val"));
		}
		$root->appendChild($arglist);
	}
}
