# $Id: Confirm.pm 35785 2011-10-17 15:25:15Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/Logout/Confirm.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Confirm;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $logout = $self->construct('logout' =>
		[warn => $req->effective_warn],
	);
	$self->setDocumentElement($self->construct('confirm-logout' => $logout));

	if(my $service = $req->service) {
		$logout->appendTextChild(service => $service);
	}

	if(my $url = $req->back_url) {
		$logout->appendTextChild(url => $url);
	}
}
