# $Id: Server.pm 35210 2011-07-12 08:26:54Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/WS/Server.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::Server;

use Aselect::WS::Server::Error;
use Aselect::WS::Server::Request;
use Aselect::WS::Responder::Document;

use Aselect::Handler -self;

field 'requests';

sub handle {
	my $req = new Aselect::WS::Server::Request(cfg => $self, ctx => shift);
	my $res = eval {
		my $handler = $self->requests->{$req->request}
			or die "0030 Unknown request\n";
		$handler->handle($req);
	};
	if($@) {
		my $exc = $@;
		die $exc if ref $exc || $exc !~ /^(\d\d\d\d)(?: (.*))?$/;
		my $err = new Aselect::WS::Server::Error(cfg => $self, ctx => $req, code => $1, message => $2);
		my $doc = new Aselect::WS::Responder::Document(req => $err);
		die $doc->response;
	}
	return $res;
}
