# $Id: Document.pm 34998 2011-06-09 08:37:22Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/WS/ValidateCASv2/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::ValidateCASv2::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	my $serviceResponse = $self->createElementNS('http://www.yale.edu/tp/cas', 'cas:serviceResponse');
	$self->setDocumentElement($serviceResponse);

	my $uid = $req->uid;

	my $code = $req->service && $req->ticket
		? 'INVALID_TICKET'
		: 'INVALID_REQUEST';

	my $answer = defined $uid
		? $self->construct('cas:authenticationSuccess' => ['cas:user' => $uid])
		: $self->construct('cas:authenticationFailure' => {code => $code});

	$serviceResponse->appendChild($answer);
}
