# $Id: Document.pm 36088 2011-11-23 18:56:52Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/Password/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Document;

use Aselect::UI::Login::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(password =>
		[lt => $req->create_lt]
	);
	$self->setDocumentElement($root);

	if(my $username = $req->username || $req->uid) {
		$root->appendChild($self->construct(username => $username));
	}

	if(my $message = $req->message) {
		$root->appendChild($self->construct(message => $message));
	}
}
