# $Id: Account.pm 34998 2011-06-09 08:37:22Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/SPNEGO/Account.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO::Account;

use Aselect::UI::Document -self;

sub build {
	$self->setDocumentElement($self->construct('spnego-account',
		[uid => $self->req->spnego_uid]
	));
}

sub response {
	my $res = super;
	my $cookie = $self->bakecookie(SPNEGO => 'func');
	$cookie->expire('1y');
	$res->setcookie($cookie);
	return $res;
}
