# $Id: Request.pm 36053 2011-11-17 19:01:14Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::Request;

use Xyzzy::Util qw(parse_bool);

use Xyzzy::Request -self;

our @EXPORT_BASE = qw(bool_string bool_param);

sub bool_string() {
	return eval { parse_bool(shift) ? 'true' : 'false' };
}

sub bool_param(*) {
	my $name = shift;
	if(ref $name) {
		my $self = $name;
		$name = shift;
		my ($val) = $self->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	}
	my $package = caller;
	Clarity::Internals::field($package, $name, sub {
		my ($val) = shift->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	});
}

field dir => sub { shift->cfg->dir };
field crypto => sub { shift->cfg->crypto };
field request_timeout => sub { shift->cfg->request_timeout };
field org => sub { shift->cfg->organization };

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

bool_param renew;
