# $Id: Request.pm 34999 2011-06-09 09:30:44Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/VerifyCredentials/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::VerifyCredentials::Request;

use Aselect::Util;

use Aselect::WS::Responder::Request -self;

param signature => sub { die "0030 Required request parameter 'signature' not supplied\n" unless defined };
param aselect_credentials => sub { die "0030 Required request parameter 'aselect_credentials' not supplied\n" unless defined };
param local_organization => sub { die "0030 Required request parameter 'local_organization' not supplied\n" unless defined };

const requestor_origin => sub { shift->rid; return };
const requestor_id => sub { shift->rid; return };
const requestor_url => sub { shift->rid; return };

param rid => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my (undef, undef, $origin, $id, $url) =
		eval { $cfg->crypto->check_token('r', $_, $cfg->request_timeout) };
	die "0030 $@" if $@;
	$self->{requestor_origin} = $origin;
	$self->{requestor_id} = $id;
	$self->{requestor_url} = $url;
};

sub response {
	my $cfg = $self->cfg;

	my $credentials = $self->aselect_credentials;

	my (undef, undef, $requestor_id, $uid) =
		eval { $cfg->crypto->check_token('c', $credentials, $cfg->credential_timeout) };
	die "0030 $@" if $@;

	die "0004 Requestor from credentials ($requestor_id) does not match request\n"
		if $requestor_id ne $self->requestor_id;

	$self->check_signature(@{self->signature_params});

	my %response = (
		result_code => '0000',
		uid => $uid,
		organization => $cfg->organization,
		tgt_exp_time => int((time + $cfg->session_timeout) * 1000),
		authsp => 'ldap',
		authsp_level => 10,
		app_level => 10
	);

	my $origin = $self->requestor_origin;
	if($origin eq 'l') {
		$response{app_id} = $requestor_id;
	} elsif($origin eq 'r') {
		die "0004 Requestor from credentials ($requestor_id) does not match local_organization\n"
			if $requestor_id ne $self->local_organization;
	}

	@response{qw(asp asp_level)} = @response{qw(authsp authsp_level)};

	my $requestor = $cfg->requestors->{$requestor_id};
	my $attributes = $cfg->dir->attributes($uid, $requestor);
	$response{attributes} = aselect_encode(@$attributes)
		if @$attributes;

	return \%response;
}

sub signature_params {
	my $origin = $self->requestor_origin or confess 'internal error';
	return $origin eq 'l' ? [qw(a-select-server aselect_credentials rid)]
		: $origin eq 'r' ? [qw(a-select-server aselect_credentials local_organization rid)]
		: confess 'internal error';
}
