# $Id: Document.pm 36052 2011-11-17 18:43:03Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Document;

use Aselect::UI::Document -self;

sub build {
	$self->hook_next;

	my $req = $self->req;

	my $login = $self->construct('login' =>
		[warn => $req->effective_warn],
		[remember => $req->effective_remember],
	);

	if(my $rid = $req->rid) {
		$login->appendChild($self->construct(rid => $rid));
	}

	if(my $service = $req->service) {
		$login->appendChild($self->construct(service => $service));
	}

	if($req->renew) {
		$login->appendChild($self->construct(renew => 'true'));
	}

	if(my $url = $req->bare_url) {
		$login->appendChild($self->construct(url => $url));
	}

	$self->documentElement->appendChild($login);
}

sub response {
	my $res = super;
	$res->addheader('Cache-Control' => 'no-store');
	return $res;
}
