# $Id: Document.pm 36341 2012-01-15 18:20:01Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Document;

use Aselect::UI::Login::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(password =>
		[lt => scalar $req->new_session->create_lt]
	);
	$self->setDocumentElement($root);

	if(my $username = $req->username) {
		$root->appendChild($self->construct(username => $username));
	}

	if(my $message = $req->message) {
		$root->appendChild($self->construct(message => $message));
	}
}
