# $Id: Handler.pm 32376 2010-09-06 12:48:15Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/doc/Pichu/Handler.pm $

use utf8;
use strict;
use warnings;

package Pichu::Request;

use Xyzzy::Request -self;

use Aselect::Client;
use Data::Dumper;

field uid => sub { shift->aselect; return };
field org => sub { shift->aselect; return };
field attributes => sub { shift->aselect; return };

param aselect_credentials;
param rid => sub { die "no rid param\n" unless defined };

sub redirect {
	my $url = shift;
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setheader(Location => $url);
	return $res;
}

sub cookieredirect {
	my $url = $self->url;
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setheader(Location => $url);
	$res->setcookie(@_);
	return $res;
}

sub aselect {
	my $cfg = $self->cfg;
	my $app = $cfg->app_id;
	my $url = $self->url;

	if(my $ticket = $self->cookie('pichu')) {
		eval {
			my ($uid, $org) = aselect_verify_ticket($ticket);
			$self->uid($uid);
			$self->org($org);
			$self->attributes(scalar aselect_attributes($ticket));
		};
		return unless $@;
		warn "aselect_verify_ticket: $@";
	}

	if(my $cred = $self->aselect_credentials) {
		my $rid = $self->rid;
		my $ticket = eval { aselect_verify_credentials($rid, $cred) };
		die $self->cookieredirect(pichu => $ticket) if $ticket;
		die "aselect_verify_credentials: $@" if $@;
	}

	my $sso = aselect_authenticate($app, $url);
	die $self->redirect($sso);
}

package Pichu::Document;

use Xyzzy::Document::Styled -self;

sub build {
	$self->addTemplates('pichu');

	my $req = $self->req;
	my $uid = $req->uid;

	my $oi = $self->getElementById('oi');
	$oi->appendText("oi $uid!");

	my $table = $self->getElementById('attributes');
	my @attributes = @{$req->attributes};
	while(@attributes) {
		my $key = shift @attributes;
		my $val = shift @attributes;
		my $tr = $self->createElement('tr');
		$tr->appendTextChild('th', $key);
		$tr->appendTextChild('td', $val);
		$table->appendChild($tr);
	}
}

package Pichu::Error;

use Xyzzy::Document::Styled -self;

field message;

sub build {
	$self->addTemplates('error');

	my $content = $self->getElementById('content');
	$content->appendTextChild('pre', $self->message);
}

package Pichu::Handler;

use Xyzzy::Handler -self;

sub handle {
	my $req = new Pichu::Request(cfg => $self, ctx => shift);
	my $doc = new Pichu::Document(req => $req);
	my $res = eval { $doc->response };
	if($@) {
		die $@ if ref $@;
		my $doc = new Pichu::Error(req => $req, message => $@);
		die $doc->response;
	}
	return $res;
}
