# $Id: LDAP.pm 37835 2012-09-14 14:51:14Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/LDAP.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::LDAP;

use Net::LDAP;
use Net::LDAP::Filter;

use Xyzzy::LDAP -self;

# [[a b] [x y] [1 2]] ->
#   [[a x 1] [b x 1] [a y 1] [b y 1] [a x 2] [b x 2] [a y 2] [b y 2]]
sub cart() {
	my $a = [[]];
	my $b = [];
	foreach my $list (@_) {
		my @x = @$list;
		return [] unless @x;
		my $last = pop @x;
		foreach my $x (@x) {
			foreach my $e (@$a) {
				my @e = @$e;
				push @e, $x;
				push @$b, \@e;
			}
		}
		foreach my $e (@$a) {
			push @$e, $last;
			push @$b, $e;
		}
		$a = $b;
		$b = [];
	}
	return $a;
}

sub replace() {
	my ($fmt, $values, $lookup) = @_;
	@$lookup{keys %$values} = keys %$values
		unless defined $lookup;
	my $cart = cart(values %$values);
	return map {
		my %keys;
		@keys{keys %$values} = @$_;
		my $out = $fmt;
		$out =~ s/\$(?:(\$)|\{([^}]*)\}|([a-z_]\w*))/
				my $replacement = '';
				if(defined $1) {
					$replacement = '$';
				} elsif(defined $2) {
					$replacement = $keys{$lookup->{$2}};
				} elsif(defined $3) {
					$replacement = $keys{$lookup->{$3}};
				}
				$replacement
			/eig;
		$out
	} @$cart;
}

sub scan() {
	my $fmt = shift;

	my %keys;

	$fmt =~ s/\$(?:(\$)|\{([^}]*)\}|([a-z_]\w*))/
			if(defined $2) {
				undef $keys{$2};
			} elsif(defined $3) {
				undef $keys{$3};
			}
			''
		/eig;

	return [keys %keys];
}

const canon => {};

sub canonicalize {
	my $fullname = shift;

	my $canon = $self->canon;
	return $canon->{$fullname} if exists $canon->{$fullname};

	my $name = $fullname;
	$name =~ s/(;.*)//;
	my $options = $1 // '';

	if(exists $canon->{$name}) {
		my $n = $canon->{$name};
		return $canon->{$fullname} = defined $n ? $n.$options : undef;
	}

	my $schema = $self->schema;
	my $c = $schema->attribute($name);
	if(defined $c) {
		my $n = $c->{name};
		my $f = $n.$options;
		$canon->{$fullname} = $f;
		$canon->{$name} = $n;
		return $f;
	} else {
		$canon->{$name} = undef;
		return undef;
	}
}

sub attributes {
	my ($uid, $app) = @_;

	return [] unless defined $app;

	# convention: "attributes" refers to A-Select attributes,
	# while "attrs" refers to LDAP attributes
	my $attributes = $app->policy;
	return [] unless defined $attributes;
	return [] unless %$attributes;

	my $ldap = $self->connection;

	my $schema = $self->schema;
	my $canon = $self->canon;

	my %req;
	my %attrs;
	my %substs;
	ATTR: while(my ($key, $val) = each(%$attributes)) {
		my %s;
		my $attrs = scan($val);
		foreach my $a (@$attrs) {
			my $c = $self->canonicalize($a);
			next ATTR unless defined $c;
			undef $s{$c};
			undef $attrs{$c};
			$c =~ s/;.*//;
			undef $req{$c};
		}
		$substs{$key} = \%s;
	}

	my $search = $self->search($uid, [keys %req]);
	return [] unless $search->count;

	# should be only one
	foreach my $entry ($search->entries) {
		foreach my $a (keys %attrs) {
			$attrs{$a} = $entry->get_value($a, asref => 1) || [];
		}
	}

	my @res;
	while(my ($key, $val) = each(%substs)) {
		my @a = keys %$val;
		my %a; @a{@a} = @attrs{@a};
		push @res, map { $key, $_ } replace($attributes->{$key}, \%a, $canon);
	}
	return \@res;
}
