# $Id: Ticket.pm 36341 2012-01-15 18:20:01Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Ticket.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Ticket;

use Clarity -self;

field cfg;
field crypto => sub { shift->cfg->crypto };

field expiration;
field uid => undef;
field salt;
field token;

field create_nonce => sub { my $self = shift; scalar $self->crypto->create_token('n'.$self->token) };
sub check_nonce { $self->crypto->check_token('n'.$self->token, @_) }

field create_lt => sub { my $self = shift; scalar $self->crypto->create_token('lt'.$self->token) };
sub check_lt { $self->crypto->check_token('lt'.$self->token, @_) }
