# $Id: Document.pm 37565 2012-08-15 19:01:35Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Attributes/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Attributes::Document;

use Xyzzy::Util qw(iso8601);

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;
	my $cfg = $self->cfg;

	my $root = $self->construct('attributes');
	$self->setDocumentElement($root);

	if(my $uid = $req->new_session->uid) {
		my $requestors = $cfg->requestors;

		if(my $app_id = $req->app_id) {
			my $requestor = $requestors->{$app_id}
				or die $req->errorpage('app_id', undef, app_id => $app_id);
			$root->appendTextChild('app_id', $app_id);

			my $attributes = $cfg->dir->attributes($uid, $requestor);

			my %attributes;
			while(@$attributes) {
				my $key = shift @$attributes;
				my $val = shift @$attributes;
				push @{$attributes{$key}}, $val;
			}

			my $attrlist = $self->construct('attributes');
			while(my ($key, $values) = each(%attributes)) {
				$attrlist->appendChild($self->construct('attribute',
					[name => $key],
					[values => map {[value => $_]} @$values]
				));
			}
			$root->appendChild($attrlist);
		}

		my @requestors;
		while(my ($key, $val) = each(%$requestors)) {
			my $policy = $val->policy or next;
			push @requestors, $key if %$policy;
		}

		if(@requestors) {
			$root->appendChild($self->construct(requestors =>
				map {[requestor => $_]} @requestors));
		}
	}
}
